/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#pragma once

#include <arrow-glib/array.h>
#include <arrow-glib/record-batch.h>
#include <arrow-glib/schema.h>

#include <arrow-glib/output-stream.h>

G_BEGIN_DECLS

#define GARROW_TYPE_RECORD_BATCH_WRITER (garrow_record_batch_writer_get_type())
GARROW_AVAILABLE_IN_ALL
G_DECLARE_DERIVABLE_TYPE(GArrowRecordBatchWriter,
                         garrow_record_batch_writer,
                         GARROW,
                         RECORD_BATCH_WRITER,
                         GObject)
struct _GArrowRecordBatchWriterClass
{
  GObjectClass parent_class;
};

GARROW_AVAILABLE_IN_ALL
gboolean
garrow_record_batch_writer_write_record_batch(GArrowRecordBatchWriter *writer,
                                              GArrowRecordBatch *record_batch,
                                              GError **error);
GARROW_AVAILABLE_IN_ALL
gboolean
garrow_record_batch_writer_write_table(GArrowRecordBatchWriter *writer,
                                       GArrowTable *table,
                                       GError **error);
GARROW_AVAILABLE_IN_ALL
gboolean
garrow_record_batch_writer_close(GArrowRecordBatchWriter *writer, GError **error);

GARROW_AVAILABLE_IN_18_0
gboolean
garrow_record_batch_writer_is_closed(GArrowRecordBatchWriter *writer);

#define GARROW_TYPE_RECORD_BATCH_STREAM_WRITER                                           \
  (garrow_record_batch_stream_writer_get_type())
GARROW_AVAILABLE_IN_ALL
G_DECLARE_DERIVABLE_TYPE(GArrowRecordBatchStreamWriter,
                         garrow_record_batch_stream_writer,
                         GARROW,
                         RECORD_BATCH_STREAM_WRITER,
                         GArrowRecordBatchWriter)
struct _GArrowRecordBatchStreamWriterClass
{
  GArrowRecordBatchWriterClass parent_class;
};

GARROW_AVAILABLE_IN_ALL
GArrowRecordBatchStreamWriter *
garrow_record_batch_stream_writer_new(GArrowOutputStream *sink,
                                      GArrowSchema *schema,
                                      GError **error);

#define GARROW_TYPE_RECORD_BATCH_FILE_WRITER (garrow_record_batch_file_writer_get_type())
GARROW_AVAILABLE_IN_ALL
G_DECLARE_DERIVABLE_TYPE(GArrowRecordBatchFileWriter,
                         garrow_record_batch_file_writer,
                         GARROW,
                         RECORD_BATCH_FILE_WRITER,
                         GArrowRecordBatchStreamWriter)
struct _GArrowRecordBatchFileWriterClass
{
  GArrowRecordBatchStreamWriterClass parent_class;
};

GARROW_AVAILABLE_IN_ALL
GArrowRecordBatchFileWriter *
garrow_record_batch_file_writer_new(GArrowOutputStream *sink,
                                    GArrowSchema *schema,
                                    GError **error);

/**
 * GArrowCSVQuotingStyle:
 * @GARROW_CSV_QUOTING_STYLE_NEEDED: Only enclose values in quotes which need them.
 * @GARROW_CSV_QUOTING_STYLE_ALL_VALID: Enclose all valid values in quotes.
 * @GARROW_CSV_QUOTING_STYLE_NONE: Do not enclose any values in quotes.
 *
 * They are corresponding to `arrow::csv::QuotingStyle` values.
 *
 * Since: 23.0.0
 */
typedef enum {
  GARROW_CSV_QUOTING_STYLE_NEEDED,
  GARROW_CSV_QUOTING_STYLE_ALL_VALID,
  GARROW_CSV_QUOTING_STYLE_NONE,
} GArrowCSVQuotingStyle;

#define GARROW_TYPE_CSV_WRITE_OPTIONS (garrow_csv_write_options_get_type())
GARROW_AVAILABLE_IN_23_0
G_DECLARE_DERIVABLE_TYPE(
  GArrowCSVWriteOptions, garrow_csv_write_options, GARROW, CSV_WRITE_OPTIONS, GObject)
struct _GArrowCSVWriteOptionsClass
{
  GObjectClass parent_class;
};

GARROW_AVAILABLE_IN_23_0
GArrowCSVWriteOptions *
garrow_csv_write_options_new(void);

#define GARROW_TYPE_CSV_WRITER (garrow_csv_writer_get_type())
GARROW_AVAILABLE_IN_23_0
G_DECLARE_DERIVABLE_TYPE(
  GArrowCSVWriter, garrow_csv_writer, GARROW, CSV_WRITER, GArrowRecordBatchWriter)
struct _GArrowCSVWriterClass
{
  GArrowRecordBatchWriterClass parent_class;
};

GARROW_AVAILABLE_IN_23_0
GArrowCSVWriter *
garrow_csv_writer_new(GArrowOutputStream *sink,
                      GArrowSchema *schema,
                      GArrowCSVWriteOptions *options,
                      GError **error);

G_END_DECLS
