/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.time.Duration;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.HandleFactory;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;

class HandleFactoryImpl
implements HandleFactory,
LedgerStorage.LedgerDeletionListener {
    private final ConcurrentLongHashMap<LedgerDescriptor> ledgers;
    private final ConcurrentLongHashMap<LedgerDescriptor> readOnlyLedgers;
    private final Cache<Long, Boolean> recentlyFencedAndDeletedLedgers = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofDays(7L)).build();
    final LedgerStorage ledgerStorage;

    HandleFactoryImpl(LedgerStorage ledgerStorage) {
        this.ledgerStorage = ledgerStorage;
        this.ledgers = ConcurrentLongHashMap.newBuilder().build();
        this.readOnlyLedgers = ConcurrentLongHashMap.newBuilder().build();
        ledgerStorage.registerLedgerDeletionListener(this);
    }

    @Override
    public LedgerDescriptor getHandle(long ledgerId, byte[] masterKey, boolean journalReplay) throws IOException, BookieException {
        LedgerDescriptor handle = this.ledgers.get(ledgerId);
        if (handle == null) {
            if (!journalReplay && this.recentlyFencedAndDeletedLedgers.getIfPresent((Object)ledgerId) != null) {
                throw BookieException.create(-112);
            }
            handle = LedgerDescriptor.create(masterKey, ledgerId, this.ledgerStorage);
            this.ledgers.putIfAbsent(ledgerId, handle);
        }
        handle.checkAccess(masterKey);
        return handle;
    }

    @Override
    public LedgerDescriptor getReadOnlyHandle(long ledgerId) throws IOException, Bookie.NoLedgerException {
        LedgerDescriptor handle = this.readOnlyLedgers.get(ledgerId);
        if (handle == null) {
            handle = LedgerDescriptor.createReadOnly(ledgerId, this.ledgerStorage);
            this.readOnlyLedgers.putIfAbsent(ledgerId, handle);
        }
        return handle;
    }

    private void markIfConflictWritingOccurs(long ledgerId) {
        LedgerDescriptor ledgerDescriptor = this.ledgers.get(ledgerId);
        try {
            if (ledgerDescriptor != null && ledgerDescriptor.isFenced()) {
                this.recentlyFencedAndDeletedLedgers.put((Object)ledgerId, (Object)true);
            }
        }
        catch (IOException | BookieException ex) {
            this.recentlyFencedAndDeletedLedgers.put((Object)ledgerId, (Object)true);
        }
    }

    @Override
    public void ledgerDeleted(long ledgerId) {
        this.markIfConflictWritingOccurs(ledgerId);
        this.ledgers.remove(ledgerId);
        this.readOnlyLedgers.remove(ledgerId);
    }
}

