/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCacheTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ResponseCacheTest.class);

    @BeforeEach
    public void setup() throws Exception {
        System.setProperty("zookeeper.maxResponseCacheSize", "32");
        System.setProperty("zookeeper.maxGetChildrenResponseCacheSize", "64");
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.maxResponseCacheSize");
        System.clearProperty("zookeeper.maxGetChildrenResponseCacheSize");
    }

    @Test
    public void testResponseCache() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            this.performCacheTest((ZooKeeper)zk, "/cache", true);
            this.performCacheTest((ZooKeeper)zk, "/nocache", false);
        }
    }

    private void checkCacheStatus(long expectedHits, long expectedMisses, String cacheHitMetricsName, String cacheMissMetricsName) {
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)expectedHits, (Object)metrics.get(cacheHitMetricsName));
        Assertions.assertEquals((Object)expectedMisses, (Object)metrics.get(cacheMissMetricsName));
    }

    public void performCacheTest(ZooKeeper zk, String path, boolean useCache) throws Exception {
        int i;
        ServerMetrics.getMetrics().resetAll();
        Stat writeStat = new Stat();
        Stat readStat = new Stat();
        byte[] readData = null;
        int reads = 10;
        long expectedHits = 0L;
        long expectedMisses = 0L;
        ZooKeeperServer zks = this.serverFactory.getZooKeeperServer();
        zks.setResponseCachingEnabled(useCache);
        LOG.info("caching: {}", (Object)useCache);
        if (useCache) {
            Assertions.assertEquals((int)zks.getReadResponseCache().getCacheSize(), (int)32);
            Assertions.assertEquals((int)zks.getGetChildrenResponseCache().getCacheSize(), (int)64);
        }
        byte[] writeData = "test1".getBytes();
        zk.create(path, writeData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, writeStat);
        for (i = 0; i < reads; ++i) {
            readData = zk.getData(path, false, readStat);
            Assertions.assertArrayEquals((byte[])writeData, (byte[])readData);
            Assertions.assertEquals((Object)writeStat, (Object)readStat);
        }
        if (useCache) {
            ++expectedMisses;
            expectedHits += (long)(reads - 1);
        }
        this.checkCacheStatus(expectedHits, expectedMisses, "response_packet_cache_hits", "response_packet_cache_misses");
        writeData = "test2".getBytes();
        writeStat = zk.setData(path, writeData, -1);
        for (i = 0; i < 10; ++i) {
            readData = zk.getData(path, false, readStat);
            Assertions.assertArrayEquals((byte[])writeData, (byte[])readData);
            Assertions.assertEquals((Object)writeStat, (Object)readStat);
        }
        if (useCache) {
            ++expectedMisses;
            expectedHits += (long)(reads - 1);
        }
        this.checkCacheStatus(expectedHits, expectedMisses, "response_packet_cache_hits", "response_packet_cache_misses");
        zk.create(path + "/child", "child".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        readData = zk.getData(path, false, readStat);
        if (useCache) {
            ++expectedMisses;
        }
        Assertions.assertArrayEquals((byte[])writeData, (byte[])readData);
        Assertions.assertNotSame((Object)writeStat, (Object)readStat);
        this.checkCacheStatus(expectedHits, expectedMisses, "response_packet_cache_hits", "response_packet_cache_misses");
        ServerMetrics.getMetrics().resetAll();
        expectedHits = 0L;
        expectedMisses = 0L;
        this.createPath(path + "/a", zk);
        this.createPath(path + "/a/b", zk);
        this.createPath(path + "/a/c", zk);
        this.createPath(path + "/a/b/d", zk);
        this.createPath(path + "/a/b/e", zk);
        this.createPath(path + "/a/b/e/f", zk);
        this.createPath(path + "/a/b/e/g", zk);
        this.createPath(path + "/a/b/e/h", zk);
        this.checkPath(path + "/a", zk, 2);
        this.checkPath(path + "/a/b", zk, 2);
        this.checkPath(path + "/a/c", zk, 0);
        this.checkPath(path + "/a/b/d", zk, 0);
        this.checkPath(path + "/a/b/e", zk, 3);
        this.checkPath(path + "/a/b/e/h", zk, 0);
        if (useCache) {
            expectedMisses += 6L;
        }
        this.checkCacheStatus(expectedHits, expectedMisses, "response_packet_get_children_cache_hits", "response_packet_get_children_cache_misses");
        this.checkPath(path + "/a", zk, 2);
        this.checkPath(path + "/a/b", zk, 2);
        this.checkPath(path + "/a/c", zk, 0);
        if (useCache) {
            expectedHits += 3L;
        }
        this.checkCacheStatus(expectedHits, expectedMisses, "response_packet_get_children_cache_hits", "response_packet_get_children_cache_misses");
    }

    private void createPath(String path, ZooKeeper zk) throws Exception {
        zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
    }

    private void checkPath(String path, ZooKeeper zk, int expectedNumberOfChildren) throws Exception {
        List c2;
        Stat stat = zk.exists(path, false);
        List c1 = zk.getChildren(path, false);
        if (!c1.equals(c2 = zk.getChildren(path, false, stat))) {
            Assertions.fail((String)"children lists from getChildren()/getChildren2() do not match");
        }
        Assertions.assertEquals((int)c1.size(), (int)expectedNumberOfChildren);
        if (!stat.equals((Object)stat)) {
            Assertions.fail((String)"stats from exists()/getChildren2() do not match");
        }
    }
}

