/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.base.CaseFormat;

public class BuiltInNameConversions {
    public static String toCassandraName(String javaName, NamingConvention convention) {
        switch (convention) {
            case CASE_INSENSITIVE: {
                return javaName;
            }
            case EXACT_CASE: {
                return Strings.doubleQuote((String)javaName);
            }
            case LOWER_CAMEL_CASE: {
                return Strings.doubleQuote((String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, javaName));
            }
            case UPPER_CAMEL_CASE: {
                return Strings.doubleQuote((String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, javaName));
            }
            case SNAKE_CASE_INSENSITIVE: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, javaName);
            }
            case UPPER_SNAKE_CASE: {
                return Strings.doubleQuote((String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, javaName));
            }
            case UPPER_CASE: {
                return Strings.doubleQuote((String)javaName.toUpperCase());
            }
        }
        throw new AssertionError((Object)("Unsupported convention: " + convention));
    }
}

