/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunctionFactory;
import org.junit.Assert;
import org.junit.Test;

public class NeighbourhoodSizeFunctionFactoryTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testExponentialDecayPrecondition1() {
        NeighbourhoodSizeFunctionFactory.exponentialDecay((double)0.0, (double)0.0, (long)2L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testExponentialDecayPrecondition2() {
        NeighbourhoodSizeFunctionFactory.exponentialDecay((double)1.0, (double)0.0, (long)2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testExponentialDecayPrecondition3() {
        NeighbourhoodSizeFunctionFactory.exponentialDecay((double)1.0, (double)1.0, (long)100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testExponentialDecayPrecondition4() {
        NeighbourhoodSizeFunctionFactory.exponentialDecay((double)2.0, (double)1.0, (long)0L);
    }

    @Test
    public void testExponentialDecayTrivial() {
        int n = 65;
        int init = 4;
        int valueAtN = 3;
        NeighbourhoodSizeFunction f = NeighbourhoodSizeFunctionFactory.exponentialDecay((double)4.0, (double)3.0, (long)65L);
        Assert.assertEquals((long)4L, (long)f.value(0L));
        Assert.assertEquals((long)3L, (long)f.value(65L));
        Assert.assertEquals((long)0L, (long)f.value(Long.MAX_VALUE));
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testQuasiSigmoidDecayPrecondition1() {
        NeighbourhoodSizeFunctionFactory.quasiSigmoidDecay((double)0.0, (double)-1.0, (long)2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testQuasiSigmoidDecayPrecondition3() {
        NeighbourhoodSizeFunctionFactory.quasiSigmoidDecay((double)1.0, (double)0.0, (long)100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testQuasiSigmoidDecayPrecondition4() {
        NeighbourhoodSizeFunctionFactory.quasiSigmoidDecay((double)1.0, (double)-1.0, (long)0L);
    }

    @Test
    public void testQuasiSigmoidDecayTrivial() {
        int n = 65;
        double init = 4.0;
        double slope = -0.1;
        NeighbourhoodSizeFunction f = NeighbourhoodSizeFunctionFactory.quasiSigmoidDecay((double)4.0, (double)-0.1, (long)65L);
        Assert.assertEquals((double)4.0, (double)f.value(0L), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(Long.MAX_VALUE), (double)0.0);
    }
}

