/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.inference;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.ZeroException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.statistics.distribution.ChiSquaredDistribution;

public class GTest {
    public double g(double[] expected, long[] observed) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException {
        if (expected.length < 2) {
            throw new DimensionMismatchException(expected.length, 2);
        }
        if (expected.length != observed.length) {
            throw new DimensionMismatchException(expected.length, observed.length);
        }
        MathArrays.checkPositive((double[])expected);
        MathArrays.checkNonNegative((long[])observed);
        double sumExpected = 0.0;
        double sumObserved = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            sumExpected += expected[i];
            sumObserved += (double)observed[i];
        }
        double ratio = 1.0;
        boolean rescale = false;
        if (JdkMath.abs((double)(sumExpected - sumObserved)) > 1.0E-5) {
            ratio = sumObserved / sumExpected;
            rescale = true;
        }
        double sum = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double dev = rescale ? JdkMath.log((double)((double)observed[i] / (ratio * expected[i]))) : JdkMath.log((double)((double)observed[i] / expected[i]));
            sum += (double)observed[i] * dev;
        }
        return 2.0 * sum;
    }

    public double gTest(double[] expected, long[] observed) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, MaxCountExceededException {
        ChiSquaredDistribution distribution = ChiSquaredDistribution.of((double)((double)expected.length - 1.0));
        return distribution.survivalProbability(this.g(expected, observed));
    }

    public double gTestIntrinsic(double[] expected, long[] observed) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, MaxCountExceededException {
        ChiSquaredDistribution distribution = ChiSquaredDistribution.of((double)((double)expected.length - 2.0));
        return distribution.survivalProbability(this.g(expected, observed));
    }

    public boolean gTest(double[] expected, long[] observed, double alpha) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, OutOfRangeException, MaxCountExceededException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)alpha, (Number)0, (Number)0.5);
        }
        return this.gTest(expected, observed) < alpha;
    }

    private double entropy(long[][] k) {
        int j;
        int i;
        double h = 0.0;
        double sumK = 0.0;
        for (i = 0; i < k.length; ++i) {
            for (j = 0; j < k[i].length; ++j) {
                sumK += (double)k[i][j];
            }
        }
        for (i = 0; i < k.length; ++i) {
            for (j = 0; j < k[i].length; ++j) {
                if (k[i][j] == 0L) continue;
                double pIJ = (double)k[i][j] / sumK;
                h += pIJ * JdkMath.log((double)pIJ);
            }
        }
        return -h;
    }

    private double entropy(long[] k) {
        int i;
        double h = 0.0;
        double sumK = 0.0;
        for (i = 0; i < k.length; ++i) {
            sumK += (double)k[i];
        }
        for (i = 0; i < k.length; ++i) {
            if (k[i] == 0L) continue;
            double pI = (double)k[i] / sumK;
            h += pI * JdkMath.log((double)pI);
        }
        return -h;
    }

    public double gDataSetsComparison(long[] observed1, long[] observed2) throws DimensionMismatchException, NotPositiveException, ZeroException {
        if (observed1.length < 2) {
            throw new DimensionMismatchException(observed1.length, 2);
        }
        if (observed1.length != observed2.length) {
            throw new DimensionMismatchException(observed1.length, observed2.length);
        }
        MathArrays.checkNonNegative((long[])observed1);
        MathArrays.checkNonNegative((long[])observed2);
        long countSum1 = 0L;
        long countSum2 = 0L;
        long[] collSums = new long[observed1.length];
        long[][] k = new long[2][observed1.length];
        for (int i = 0; i < observed1.length; ++i) {
            if (observed1[i] == 0L && observed2[i] == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, new Object[]{i});
            }
            countSum1 += observed1[i];
            countSum2 += observed2[i];
            collSums[i] = observed1[i] + observed2[i];
            k[0][i] = observed1[i];
            k[1][i] = observed2[i];
        }
        if (countSum1 == 0L || countSum2 == 0L) {
            throw new ZeroException();
        }
        long[] rowSums = new long[]{countSum1, countSum2};
        double sum = (double)countSum1 + (double)countSum2;
        return 2.0 * sum * (this.entropy(rowSums) + this.entropy(collSums) - this.entropy(k));
    }

    public double rootLogLikelihoodRatio(long k11, long k12, long k21, long k22) {
        double llr = this.gDataSetsComparison(new long[]{k11, k12}, new long[]{k21, k22});
        double sqrt = JdkMath.sqrt((double)llr);
        if ((double)k11 / (double)(k11 + k12) < (double)k21 / (double)(k21 + k22)) {
            sqrt = -sqrt;
        }
        return sqrt;
    }

    public double gTestDataSetsComparison(long[] observed1, long[] observed2) throws DimensionMismatchException, NotPositiveException, ZeroException, MaxCountExceededException {
        ChiSquaredDistribution distribution = ChiSquaredDistribution.of((double)((double)observed1.length - 1.0));
        return distribution.survivalProbability(this.gDataSetsComparison(observed1, observed2));
    }

    public boolean gTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws DimensionMismatchException, NotPositiveException, ZeroException, OutOfRangeException, MaxCountExceededException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)alpha, (Number)0, (Number)0.5);
        }
        return this.gTestDataSetsComparison(observed1, observed2) < alpha;
    }
}

