/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.differentiation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.FieldElement;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.core.Sum;

public final class SparseGradient
implements RealFieldElement<SparseGradient> {
    private double value;
    private final Map<Integer, Double> derivatives;

    private SparseGradient(double value, Map<Integer, Double> derivatives) {
        this.value = value;
        this.derivatives = new HashMap<Integer, Double>();
        if (derivatives != null) {
            this.derivatives.putAll(derivatives);
        }
    }

    private SparseGradient(double value, double scale, Map<Integer, Double> derivatives) {
        this.value = value;
        this.derivatives = new HashMap<Integer, Double>();
        if (derivatives != null) {
            for (Map.Entry<Integer, Double> entry : derivatives.entrySet()) {
                this.derivatives.put(entry.getKey(), scale * entry.getValue());
            }
        }
    }

    public static SparseGradient createConstant(double value) {
        return new SparseGradient(value, Collections.emptyMap());
    }

    public static SparseGradient createVariable(int idx, double value) {
        return new SparseGradient(value, Collections.singletonMap(idx, 1.0));
    }

    public int numVars() {
        return this.derivatives.size();
    }

    public double getDerivative(int index) {
        Double out = this.derivatives.get(index);
        return out == null ? 0.0 : out;
    }

    public double getValue() {
        return this.value;
    }

    public double getReal() {
        return this.value;
    }

    public SparseGradient add(SparseGradient a) {
        SparseGradient out = new SparseGradient(this.value + a.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, entry.getValue());
                continue;
            }
            out.derivatives.put(id, old + entry.getValue());
        }
        return out;
    }

    public void addInPlace(SparseGradient a) {
        this.value += a.value;
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = this.derivatives.get(id);
            if (old == null) {
                this.derivatives.put(id, entry.getValue());
                continue;
            }
            this.derivatives.put(id, old + entry.getValue());
        }
    }

    public SparseGradient add(double c) {
        return new SparseGradient(this.value + c, this.derivatives);
    }

    public SparseGradient subtract(SparseGradient a) {
        SparseGradient out = new SparseGradient(this.value - a.value, this.derivatives);
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, -entry.getValue().doubleValue());
                continue;
            }
            out.derivatives.put(id, old - entry.getValue());
        }
        return out;
    }

    public SparseGradient subtract(double c) {
        return new SparseGradient(this.value - c, this.derivatives);
    }

    public SparseGradient multiply(SparseGradient a) {
        SparseGradient out = new SparseGradient(this.value * a.value, Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), a.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, this.value * entry.getValue());
                continue;
            }
            out.derivatives.put(id, old + this.value * entry.getValue());
        }
        return out;
    }

    public void multiplyInPlace(SparseGradient a) {
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            this.derivatives.put(entry.getKey(), a.value * entry.getValue());
        }
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = this.derivatives.get(id);
            if (old == null) {
                this.derivatives.put(id, this.value * entry.getValue());
                continue;
            }
            this.derivatives.put(id, old + this.value * entry.getValue());
        }
        this.value *= a.value;
    }

    public SparseGradient multiply(double c) {
        return new SparseGradient(this.value * c, c, this.derivatives);
    }

    public SparseGradient multiply(int n) {
        return new SparseGradient(this.value * (double)n, n, this.derivatives);
    }

    public SparseGradient divide(SparseGradient a) {
        SparseGradient out = new SparseGradient(this.value / a.value, Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), entry.getValue() / a.value);
        }
        for (Map.Entry<Integer, Double> entry : a.derivatives.entrySet()) {
            int id = entry.getKey();
            Double old = out.derivatives.get(id);
            if (old == null) {
                out.derivatives.put(id, -out.value / a.value * entry.getValue());
                continue;
            }
            out.derivatives.put(id, old - out.value / a.value * entry.getValue());
        }
        return out;
    }

    public SparseGradient divide(double c) {
        return new SparseGradient(this.value / c, 1.0 / c, this.derivatives);
    }

    public SparseGradient negate() {
        return new SparseGradient(-this.value, -1.0, this.derivatives);
    }

    public Field<SparseGradient> getField() {
        return new Field<SparseGradient>(){

            public SparseGradient getZero() {
                return SparseGradient.createConstant(0.0);
            }

            public SparseGradient getOne() {
                return SparseGradient.createConstant(1.0);
            }

            public Class<? extends FieldElement<SparseGradient>> getRuntimeClass() {
                return SparseGradient.class;
            }
        };
    }

    public SparseGradient remainder(double a) {
        return new SparseGradient(JdkMath.IEEEremainder((double)this.value, (double)a), this.derivatives);
    }

    public SparseGradient remainder(SparseGradient a) {
        double rem = JdkMath.IEEEremainder((double)this.value, (double)a.value);
        double k = JdkMath.rint((double)((this.value - rem) / a.value));
        return this.subtract(a.multiply(k));
    }

    public SparseGradient abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return this.negate();
        }
        return this;
    }

    public SparseGradient ceil() {
        return SparseGradient.createConstant(JdkMath.ceil((double)this.value));
    }

    public SparseGradient floor() {
        return SparseGradient.createConstant(JdkMath.floor((double)this.value));
    }

    public SparseGradient rint() {
        return SparseGradient.createConstant(JdkMath.rint((double)this.value));
    }

    public long round() {
        return JdkMath.round((double)this.value);
    }

    public SparseGradient signum() {
        return SparseGradient.createConstant(JdkMath.signum((double)this.value));
    }

    public SparseGradient copySign(SparseGradient sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign.value);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    public SparseGradient copySign(double sign) {
        long m = Double.doubleToLongBits(this.value);
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    public SparseGradient scalb(int n) {
        SparseGradient out = new SparseGradient(JdkMath.scalb((double)this.value, (int)n), Collections.emptyMap());
        for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
            out.derivatives.put(entry.getKey(), JdkMath.scalb((double)entry.getValue(), (int)n));
        }
        return out;
    }

    public SparseGradient hypot(SparseGradient y) {
        int expY;
        if (Double.isInfinite(this.value) || Double.isInfinite(y.value)) {
            return SparseGradient.createConstant(Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(this.value) || Double.isNaN(y.value)) {
            return SparseGradient.createConstant(Double.NaN);
        }
        int expX = JdkMath.getExponent((double)this.value);
        if (expX > (expY = JdkMath.getExponent((double)y.value)) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        SparseGradient scaledX = this.scalb(-middleExp);
        SparseGradient scaledY = y.scalb(-middleExp);
        SparseGradient scaledH = scaledX.multiply(scaledX).add(scaledY.multiply(scaledY)).sqrt();
        return scaledH.scalb(middleExp);
    }

    public static SparseGradient hypot(SparseGradient x, SparseGradient y) {
        return x.hypot(y);
    }

    public SparseGradient reciprocal() {
        return new SparseGradient(1.0 / this.value, -1.0 / (this.value * this.value), this.derivatives);
    }

    public SparseGradient sqrt() {
        double sqrt = JdkMath.sqrt((double)this.value);
        return new SparseGradient(sqrt, 0.5 / sqrt, this.derivatives);
    }

    public SparseGradient cbrt() {
        double cbrt = JdkMath.cbrt((double)this.value);
        return new SparseGradient(cbrt, 1.0 / (3.0 * cbrt * cbrt), this.derivatives);
    }

    public SparseGradient rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        double root = JdkMath.pow((double)this.value, (double)(1.0 / (double)n));
        return new SparseGradient(root, 1.0 / ((double)n * JdkMath.pow((double)root, (double)(n - 1))), this.derivatives);
    }

    public SparseGradient pow(double p) {
        return new SparseGradient(JdkMath.pow((double)this.value, (double)p), p * JdkMath.pow((double)this.value, (double)(p - 1.0)), this.derivatives);
    }

    public SparseGradient pow(int n) {
        if (n == 0) {
            return (SparseGradient)this.getField().getOne();
        }
        double valueNm1 = JdkMath.pow((double)this.value, (double)(n - 1));
        return new SparseGradient(this.value * valueNm1, (double)n * valueNm1, this.derivatives);
    }

    public SparseGradient pow(SparseGradient e) {
        return this.log().multiply(e).exp();
    }

    public static SparseGradient pow(double a, SparseGradient x) {
        if (a == 0.0) {
            if (x.value == 0.0) {
                return x.compose(1.0, Double.NEGATIVE_INFINITY);
            }
            if (x.value < 0.0) {
                return x.compose(Double.NaN, Double.NaN);
            }
            return (SparseGradient)x.getField().getZero();
        }
        double ax = JdkMath.pow((double)a, (double)x.value);
        return new SparseGradient(ax, ax * JdkMath.log((double)a), x.derivatives);
    }

    public SparseGradient exp() {
        double e = JdkMath.exp((double)this.value);
        return new SparseGradient(e, e, this.derivatives);
    }

    public SparseGradient expm1() {
        return new SparseGradient(JdkMath.expm1((double)this.value), JdkMath.exp((double)this.value), this.derivatives);
    }

    public SparseGradient log() {
        return new SparseGradient(JdkMath.log((double)this.value), 1.0 / this.value, this.derivatives);
    }

    public SparseGradient log10() {
        return new SparseGradient(JdkMath.log10((double)this.value), 1.0 / (JdkMath.log((double)10.0) * this.value), this.derivatives);
    }

    public SparseGradient log1p() {
        return new SparseGradient(JdkMath.log1p((double)this.value), 1.0 / (1.0 + this.value), this.derivatives);
    }

    public SparseGradient cos() {
        return new SparseGradient(JdkMath.cos((double)this.value), -JdkMath.sin((double)this.value), this.derivatives);
    }

    public SparseGradient sin() {
        return new SparseGradient(JdkMath.sin((double)this.value), JdkMath.cos((double)this.value), this.derivatives);
    }

    public SparseGradient tan() {
        double t = JdkMath.tan((double)this.value);
        return new SparseGradient(t, 1.0 + t * t, this.derivatives);
    }

    public SparseGradient acos() {
        return new SparseGradient(JdkMath.acos((double)this.value), -1.0 / JdkMath.sqrt((double)(1.0 - this.value * this.value)), this.derivatives);
    }

    public SparseGradient asin() {
        return new SparseGradient(JdkMath.asin((double)this.value), 1.0 / JdkMath.sqrt((double)(1.0 - this.value * this.value)), this.derivatives);
    }

    public SparseGradient atan() {
        return new SparseGradient(JdkMath.atan((double)this.value), 1.0 / (1.0 + this.value * this.value), this.derivatives);
    }

    public SparseGradient atan2(SparseGradient x) {
        SparseGradient a;
        SparseGradient r = this.multiply(this).add(x.multiply(x)).sqrt();
        if (x.value >= 0.0) {
            a = this.divide(r.add(x)).atan().multiply(2);
        } else {
            SparseGradient tmp = this.divide(r.subtract(x)).atan().multiply(-2);
            a = tmp.add(tmp.value <= 0.0 ? -JdkMath.PI : JdkMath.PI);
        }
        a.value = JdkMath.atan2((double)this.value, (double)x.value);
        return a;
    }

    public static SparseGradient atan2(SparseGradient y, SparseGradient x) {
        return y.atan2(x);
    }

    public SparseGradient cosh() {
        return new SparseGradient(JdkMath.cosh((double)this.value), JdkMath.sinh((double)this.value), this.derivatives);
    }

    public SparseGradient sinh() {
        return new SparseGradient(JdkMath.sinh((double)this.value), JdkMath.cosh((double)this.value), this.derivatives);
    }

    public SparseGradient tanh() {
        double t = JdkMath.tanh((double)this.value);
        return new SparseGradient(t, 1.0 - t * t, this.derivatives);
    }

    public SparseGradient acosh() {
        return new SparseGradient(JdkMath.acosh((double)this.value), 1.0 / JdkMath.sqrt((double)(this.value * this.value - 1.0)), this.derivatives);
    }

    public SparseGradient asinh() {
        return new SparseGradient(JdkMath.asinh((double)this.value), 1.0 / JdkMath.sqrt((double)(this.value * this.value + 1.0)), this.derivatives);
    }

    public SparseGradient atanh() {
        return new SparseGradient(JdkMath.atanh((double)this.value), 1.0 / (1.0 - this.value * this.value), this.derivatives);
    }

    public SparseGradient toDegrees() {
        return new SparseGradient(JdkMath.toDegrees((double)this.value), JdkMath.toDegrees((double)1.0), this.derivatives);
    }

    public SparseGradient toRadians() {
        return new SparseGradient(JdkMath.toRadians((double)this.value), JdkMath.toRadians((double)1.0), this.derivatives);
    }

    public double taylor(double ... delta) {
        double y = this.value;
        for (int i = 0; i < delta.length; ++i) {
            y += delta[i] * this.getDerivative(i);
        }
        return y;
    }

    public SparseGradient compose(double f0, double f1) {
        return new SparseGradient(f0, f1, this.derivatives);
    }

    public SparseGradient linearCombination(SparseGradient[] a, SparseGradient[] b) {
        SparseGradient out = (SparseGradient)a[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            out = out.add(a[i].multiply(b[i]));
        }
        double[] aDouble = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            aDouble[i] = a[i].getValue();
        }
        double[] bDouble = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            bDouble[i] = b[i].getValue();
        }
        out.value = Sum.ofProducts((double[])aDouble, (double[])bDouble).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(double[] a, SparseGradient[] b) {
        SparseGradient out = (SparseGradient)b[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            out = out.add(b[i].multiply(a[i]));
        }
        double[] bDouble = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            bDouble[i] = b[i].getValue();
        }
        out.value = Sum.ofProducts((double[])a, (double[])bDouble).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2));
        out.value = Sum.create().addProduct(a1.value, b1.value).addProduct(a2.value, b2.value).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2));
        out.value = Sum.create().addProduct(a1, b1.value).addProduct(a2, b2.value).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2, SparseGradient a3, SparseGradient b3) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3));
        out.value = Sum.create().addProduct(a1.value, b1.value).addProduct(a2.value, b2.value).addProduct(a3.value, b3.value).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2, double a3, SparseGradient b3) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2)).add(b3.multiply(a3));
        out.value = Sum.create().addProduct(a1, b1.value).addProduct(a2, b2.value).addProduct(a3, b3.value).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(SparseGradient a1, SparseGradient b1, SparseGradient a2, SparseGradient b2, SparseGradient a3, SparseGradient b3, SparseGradient a4, SparseGradient b4) {
        SparseGradient out = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3)).add(a4.multiply(b4));
        out.value = Sum.create().addProduct(a1.value, b1.value).addProduct(a2.value, b2.value).addProduct(a3.value, b3.value).addProduct(a4.value, b4.value).getAsDouble();
        return out;
    }

    public SparseGradient linearCombination(double a1, SparseGradient b1, double a2, SparseGradient b2, double a3, SparseGradient b3, double a4, SparseGradient b4) {
        SparseGradient out = b1.multiply(a1).add(b2.multiply(a2)).add(b3.multiply(a3)).add(b4.multiply(a4));
        out.value = Sum.create().addProduct(a1, b1.value).addProduct(a2, b2.value).addProduct(a3, b3.value).addProduct(a4, b4.value).getAsDouble();
        return out;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SparseGradient) {
            SparseGradient rhs = (SparseGradient)other;
            if (!Precision.equals((double)this.value, (double)rhs.value, (int)1)) {
                return false;
            }
            if (this.derivatives.size() != rhs.derivatives.size()) {
                return false;
            }
            for (Map.Entry<Integer, Double> entry : this.derivatives.entrySet()) {
                if (!rhs.derivatives.containsKey(entry.getKey())) {
                    return false;
                }
                if (Precision.equals((double)entry.getValue(), (double)rhs.derivatives.get(entry.getKey()), (int)1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 743 + 809 * Double.hashCode(this.value) + 167 * this.derivatives.hashCode();
    }
}

