/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.rank;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.stat.descriptive.rank.PivotingStrategy;

public class MedianOf3PivotingStrategy
implements PivotingStrategy {
    @Override
    public int pivotIndex(double[] work, int begin, int end) {
        MathArrays.verifyValues((double[])work, (int)begin, (int)(end - begin));
        int inclusiveEnd = end - 1;
        int middle = begin + (inclusiveEnd - begin) / 2;
        double wBegin = work[begin];
        double wMiddle = work[middle];
        double wEnd = work[inclusiveEnd];
        if (wBegin < wMiddle) {
            if (wMiddle < wEnd) {
                return middle;
            }
            return wBegin < wEnd ? inclusiveEnd : begin;
        }
        if (wBegin < wEnd) {
            return begin;
        }
        return wMiddle < wEnd ? inclusiveEnd : middle;
    }
}

