/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ExecuteSsisPackageActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SsisExecutionCredential;
import com.azure.resourcemanager.datafactory.models.SsisExecutionParameter;
import com.azure.resourcemanager.datafactory.models.SsisLogLocation;
import com.azure.resourcemanager.datafactory.models.SsisPackageLocation;
import com.azure.resourcemanager.datafactory.models.SsisPropertyOverride;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="ExecuteSSISPackage")
public final class ExecuteSsisPackageActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private ExecuteSsisPackageActivityTypeProperties innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteSsisPackageActivity.class);

    private ExecuteSsisPackageActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExecuteSsisPackageActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public SsisPackageLocation packageLocation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageLocation();
    }

    public ExecuteSsisPackageActivity withPackageLocation(SsisPackageLocation packageLocation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageLocation(packageLocation);
        return this;
    }

    public Object runtime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runtime();
    }

    public ExecuteSsisPackageActivity withRuntime(Object runtime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withRuntime(runtime);
        return this;
    }

    public Object loggingLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loggingLevel();
    }

    public ExecuteSsisPackageActivity withLoggingLevel(Object loggingLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withLoggingLevel(loggingLevel);
        return this;
    }

    public Object environmentPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().environmentPath();
    }

    public ExecuteSsisPackageActivity withEnvironmentPath(Object environmentPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withEnvironmentPath(environmentPath);
        return this;
    }

    public SsisExecutionCredential executionCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().executionCredential();
    }

    public ExecuteSsisPackageActivity withExecutionCredential(SsisExecutionCredential executionCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withExecutionCredential(executionCredential);
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectVia();
    }

    public ExecuteSsisPackageActivity withConnectVia(IntegrationRuntimeReference connectVia) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withConnectVia(connectVia);
        return this;
    }

    public Map<String, SsisExecutionParameter> projectParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().projectParameters();
    }

    public ExecuteSsisPackageActivity withProjectParameters(Map<String, SsisExecutionParameter> projectParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withProjectParameters(projectParameters);
        return this;
    }

    public Map<String, SsisExecutionParameter> packageParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageParameters();
    }

    public ExecuteSsisPackageActivity withPackageParameters(Map<String, SsisExecutionParameter> packageParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageParameters(packageParameters);
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().projectConnectionManagers();
    }

    public ExecuteSsisPackageActivity withProjectConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withProjectConnectionManagers(projectConnectionManagers);
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageConnectionManagers();
    }

    public ExecuteSsisPackageActivity withPackageConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageConnectionManagers(packageConnectionManagers);
        return this;
    }

    public Map<String, SsisPropertyOverride> propertyOverrides() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().propertyOverrides();
    }

    public ExecuteSsisPackageActivity withPropertyOverrides(Map<String, SsisPropertyOverride> propertyOverrides) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPropertyOverrides(propertyOverrides);
        return this;
    }

    public SsisLogLocation logLocation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logLocation();
    }

    public ExecuteSsisPackageActivity withLogLocation(SsisLogLocation logLocation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withLogLocation(logLocation);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecuteSsisPackageActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

