/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ScaleStatus represents the current status of a scale subresource.")
public class V1ScaleStatus {
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private String selector;

    public V1ScaleStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="actual number of observed instances of the scaled object.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ScaleStatus selector(String selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors")
    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ScaleStatus v1ScaleStatus = (V1ScaleStatus)o;
        return Objects.equals(this.replicas, v1ScaleStatus.replicas) && Objects.equals(this.selector, v1ScaleStatus.selector);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ScaleStatus {\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

