/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.security.keyvault.keys.cryptography.implementation.SecretProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public final class SecretKey {
    @JsonProperty(value="value")
    private String value;
    private SecretProperties properties;

    public SecretKey() {
        this.properties = new SecretProperties();
    }

    public SecretKey(String name, String value) {
        this.properties = new SecretProperties(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public SecretProperties getProperties() {
        return this.properties;
    }

    public SecretKey setProperties(SecretProperties properties) {
        Objects.requireNonNull(properties);
        properties.name = this.properties.name;
        this.properties = properties;
        return this;
    }

    @JsonProperty(value="id")
    private void unpackId(String id) {
        this.properties.unpackId(id);
    }

    @JsonProperty(value="attributes")
    private void unpackAttributes(Map<String, Object> attributes) {
        this.properties.unpackAttributes(attributes);
    }

    @JsonProperty(value="managed")
    private void unpackManaged(Boolean managed) {
        this.properties.managed = managed;
    }

    @JsonProperty(value="kid")
    private void unpackKid(String kid) {
        this.properties.keyId = kid;
    }

    @JsonProperty(value="contentType")
    private void unpackContentType(String contentType) {
        this.properties.contentType = contentType;
    }

    @JsonProperty(value="tags")
    private void unpackTags(Map<String, String> tags) {
        this.properties.tags = tags;
    }
}

