/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class HDInsightMapReduceActivityTypeProperties {
    @JsonProperty(value="storageLinkedServices")
    private List<LinkedServiceReference> storageLinkedServices;
    @JsonProperty(value="arguments")
    private List<Object> arguments;
    @JsonProperty(value="getDebugInfo")
    private HDInsightActivityDebugInfoOption getDebugInfo;
    @JsonProperty(value="className", required=true)
    private Object className;
    @JsonProperty(value="jarFilePath", required=true)
    private Object jarFilePath;
    @JsonProperty(value="jarLinkedService")
    private LinkedServiceReference jarLinkedService;
    @JsonProperty(value="jarLibs")
    private List<Object> jarLibs;
    @JsonProperty(value="defines")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> defines;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightMapReduceActivityTypeProperties.class);

    public List<LinkedServiceReference> storageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightMapReduceActivityTypeProperties withStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> arguments() {
        return this.arguments;
    }

    public HDInsightMapReduceActivityTypeProperties withArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightMapReduceActivityTypeProperties withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object className() {
        return this.className;
    }

    public HDInsightMapReduceActivityTypeProperties withClassName(Object className) {
        this.className = className;
        return this;
    }

    public Object jarFilePath() {
        return this.jarFilePath;
    }

    public HDInsightMapReduceActivityTypeProperties withJarFilePath(Object jarFilePath) {
        this.jarFilePath = jarFilePath;
        return this;
    }

    public LinkedServiceReference jarLinkedService() {
        return this.jarLinkedService;
    }

    public HDInsightMapReduceActivityTypeProperties withJarLinkedService(LinkedServiceReference jarLinkedService) {
        this.jarLinkedService = jarLinkedService;
        return this;
    }

    public List<Object> jarLibs() {
        return this.jarLibs;
    }

    public HDInsightMapReduceActivityTypeProperties withJarLibs(List<Object> jarLibs) {
        this.jarLibs = jarLibs;
        return this;
    }

    public Map<String, Object> defines() {
        return this.defines;
    }

    public HDInsightMapReduceActivityTypeProperties withDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public void validate() {
        if (this.storageLinkedServices() != null) {
            this.storageLinkedServices().forEach(e -> e.validate());
        }
        if (this.className() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property className in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (this.jarFilePath() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property jarFilePath in model HDInsightMapReduceActivityTypeProperties"));
        }
        if (this.jarLinkedService() != null) {
            this.jarLinkedService().validate();
        }
    }
}

