/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SynapseNotebookActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.BigDataPoolParametrizationReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.NotebookParameter;
import com.azure.resourcemanager.datafactory.models.SynapseNotebookReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="SynapseNotebook")
public final class SynapseNotebookActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private SynapseNotebookActivityTypeProperties innerTypeProperties = new SynapseNotebookActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SynapseNotebookActivity.class);

    private SynapseNotebookActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SynapseNotebookActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SynapseNotebookActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public SynapseNotebookActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SynapseNotebookActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SynapseNotebookActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SynapseNotebookActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public SynapseNotebookReference notebook() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().notebook();
    }

    public SynapseNotebookActivity withNotebook(SynapseNotebookReference notebook) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withNotebook(notebook);
        return this;
    }

    public BigDataPoolParametrizationReference sparkPool() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkPool();
    }

    public SynapseNotebookActivity withSparkPool(BigDataPoolParametrizationReference sparkPool) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkPool(sparkPool);
        return this;
    }

    public Map<String, NotebookParameter> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    public SynapseNotebookActivity withParameters(Map<String, NotebookParameter> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    public Object executorSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().executorSize();
    }

    public SynapseNotebookActivity withExecutorSize(Object executorSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withExecutorSize(executorSize);
        return this;
    }

    public Object conf() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().conf();
    }

    public SynapseNotebookActivity withConf(Object conf) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withConf(conf);
        return this;
    }

    public Object driverSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().driverSize();
    }

    public SynapseNotebookActivity withDriverSize(Object driverSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withDriverSize(driverSize);
        return this;
    }

    public Integer numExecutors() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().numExecutors();
    }

    public SynapseNotebookActivity withNumExecutors(Integer numExecutors) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SynapseNotebookActivityTypeProperties();
        }
        this.innerTypeProperties().withNumExecutors(numExecutors);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SynapseNotebookActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

