/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3StorageClass {
    STANDARD("STANDARD"),
    STANDARD_IA("STANDARD_IA"),
    ONEZONE_IA("ONEZONE_IA"),
    INTELLIGENT_TIERING("INTELLIGENT_TIERING"),
    GLACIER("GLACIER"),
    DEEP_ARCHIVE("DEEP_ARCHIVE"),
    OUTPOSTS("OUTPOSTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3StorageClass> VALUE_MAP;
    private final String value;

    private S3StorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3StorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3StorageClass> knownValues() {
        EnumSet<S3StorageClass> knownValues = EnumSet.allOf(S3StorageClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3StorageClass.class, S3StorageClass::toString);
    }
}

