/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;

public class ConsumeIgnoringRateLimitsCommand
implements GridCommand<Long> {
    private static final long serialVersionUID = 1L;
    private long tokensToConsume;
    private boolean bucketStateModified;
    public static final SerializationHandle<ConsumeIgnoringRateLimitsCommand> SERIALIZATION_HANDLE = new SerializationHandle<ConsumeIgnoringRateLimitsCommand>(){

        @Override
        public <S> ConsumeIgnoringRateLimitsCommand deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            long tokensToConsume = adapter.readLong(input);
            return new ConsumeIgnoringRateLimitsCommand(tokensToConsume);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ConsumeIgnoringRateLimitsCommand command) throws IOException {
            adapter.writeLong(output, command.tokensToConsume);
        }

        @Override
        public int getTypeId() {
            return 22;
        }

        @Override
        public Class<ConsumeIgnoringRateLimitsCommand> getSerializedType() {
            return ConsumeIgnoringRateLimitsCommand.class;
        }
    };

    public ConsumeIgnoringRateLimitsCommand(long limit) {
        this.tokensToConsume = limit;
    }

    @Override
    public Long execute(GridBucketState state, long currentTimeNanos) {
        state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = state.calculateDelayNanosAfterWillBePossibleToConsume(this.tokensToConsume, currentTimeNanos);
        if (nanosToCloseDeficit == Long.MAX_VALUE) {
            this.bucketStateModified = false;
            return Long.MAX_VALUE;
        }
        state.consume(this.tokensToConsume);
        this.bucketStateModified = true;
        return nanosToCloseDeficit;
    }

    @Override
    public boolean isBucketStateModified() {
        return this.bucketStateModified;
    }

    public long getTokensToConsume() {
        return this.tokensToConsume;
    }
}

