/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClientOptions;
import java.util.ArrayList;
import java.util.function.Supplier;

public final class LoggingUtil {
    public static void logTokenSuccess(ClientLogger logger, TokenRequestContext context) {
        logger.log(LogLevel.INFORMATIONAL, () -> String.format("Azure Identity => getToken() result for scopes [%s]: SUCCESS", String.join((CharSequence)", ", context.getScopes())));
    }

    public static void logTokenError(ClientLogger logger, IdentityClientOptions options, TokenRequestContext context, Throwable error) {
        LoggingUtil.logError(logger, options, () -> String.format("Azure Identity => ERROR in getToken() call for scopes [%s]: %s", String.join((CharSequence)", ", context.getScopes()), error == null ? "" : error.getMessage()));
    }

    public static void logAvailableEnvironmentVariables(ClientLogger logger, Configuration configuration) {
        String msiEndpoint = configuration.get("MSI_ENDPOINT");
        String msiSecret = configuration.get("MSI_SECRET");
        String clientId = configuration.get("AZURE_CLIENT_ID");
        String tenantId = configuration.get("AZURE_TENANT_ID");
        String clientSecret = configuration.get("AZURE_CLIENT_SECRET");
        String certPath = configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String username = configuration.get("AZURE_USERNAME");
        String password = configuration.get("AZURE_PASSWORD");
        ArrayList<String> envVars = new ArrayList<String>();
        if (msiEndpoint != null) {
            envVars.add("MSI_ENDPOINT");
        }
        if (msiSecret != null) {
            envVars.add("MSI_SECRET");
        }
        if (clientId != null) {
            envVars.add("AZURE_CLIENT_ID");
        }
        if (tenantId != null) {
            envVars.add("AZURE_TENANT_ID");
        }
        if (clientSecret != null) {
            envVars.add("AZURE_CLIENT_SECRET");
        }
        if (certPath != null) {
            envVars.add("AZURE_CLIENT_CERTIFICATE_PATH");
        }
        if (username != null) {
            envVars.add("AZURE_USERNAME");
        }
        if (password != null) {
            envVars.add("AZURE_PASSWORD");
        }
        logger.verbose("Azure Identity => Found the following environment variables: {}", new Object[]{String.join((CharSequence)", ", envVars)});
    }

    private LoggingUtil() {
    }

    public static CredentialUnavailableException logCredentialUnavailableException(ClientLogger logger, IdentityClientOptions options, CredentialUnavailableException exception) {
        logger.log(options.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), () -> exception.getMessage(), (Throwable)((Object)exception));
        return exception;
    }

    public static void logError(ClientLogger logger, IdentityClientOptions options, String message) {
        logger.log(options.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), () -> message);
    }

    public static void logError(ClientLogger logger, IdentityClientOptions options, Supplier<String> messageSupplier) {
        logger.log(options.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), messageSupplier);
    }
}

