/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ILogicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicTask<T extends AbstractParameters>
implements ILogicTask<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLogicTask.class);
    protected final TaskExecutionContext taskExecutionContext;
    protected final T taskParameters;
    protected TaskExecutionStatus taskExecutionStatus;

    public AbstractLogicTask(TaskExecutionContext taskExecutionContext) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskParameters = (AbstractParameters)this.getTaskParameterDeserializer().deserialize(taskExecutionContext.getTaskParams());
        Preconditions.checkNotNull(this.taskParameters, (Object)("Deserialize task parameters: " + taskExecutionContext.getTaskParams()));
        log.info("Success initialize parameters: \n{}", (Object)JSONUtils.toPrettyJsonString(this.taskParameters));
    }

    @Override
    public TaskExecutionStatus getTaskExecutionState() {
        return this.taskExecutionStatus;
    }

    protected boolean isRunning() {
        return this.taskExecutionStatus == TaskExecutionStatus.RUNNING_EXECUTION;
    }

    protected void onTaskRunning() {
        this.taskExecutionStatus = TaskExecutionStatus.RUNNING_EXECUTION;
    }

    protected void onTaskSuccess() {
        this.taskExecutionStatus = TaskExecutionStatus.SUCCESS;
    }

    protected void onTaskFailed() {
        this.taskExecutionStatus = TaskExecutionStatus.FAILURE;
    }

    protected void onTaskKilled() {
        this.taskExecutionStatus = TaskExecutionStatus.KILL;
    }

    protected void onTaskPaused() {
        this.taskExecutionStatus = TaskExecutionStatus.PAUSE;
    }
}

