/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1beta1EventSeries;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.")
public class V1beta1Event
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DEPRECATED_COUNT = "deprecatedCount";
    @SerializedName(value="deprecatedCount")
    private Integer deprecatedCount;
    public static final String SERIALIZED_NAME_DEPRECATED_FIRST_TIMESTAMP = "deprecatedFirstTimestamp";
    @SerializedName(value="deprecatedFirstTimestamp")
    private OffsetDateTime deprecatedFirstTimestamp;
    public static final String SERIALIZED_NAME_DEPRECATED_LAST_TIMESTAMP = "deprecatedLastTimestamp";
    @SerializedName(value="deprecatedLastTimestamp")
    private OffsetDateTime deprecatedLastTimestamp;
    public static final String SERIALIZED_NAME_DEPRECATED_SOURCE = "deprecatedSource";
    @SerializedName(value="deprecatedSource")
    private V1EventSource deprecatedSource;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private OffsetDateTime eventTime;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_REGARDING = "regarding";
    @SerializedName(value="regarding")
    private V1ObjectReference regarding;
    public static final String SERIALIZED_NAME_RELATED = "related";
    @SerializedName(value="related")
    private V1ObjectReference related;
    public static final String SERIALIZED_NAME_REPORTING_CONTROLLER = "reportingController";
    @SerializedName(value="reportingController")
    private String reportingController;
    public static final String SERIALIZED_NAME_REPORTING_INSTANCE = "reportingInstance";
    @SerializedName(value="reportingInstance")
    private String reportingInstance;
    public static final String SERIALIZED_NAME_SERIES = "series";
    @SerializedName(value="series")
    private V1beta1EventSeries series;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1beta1Event action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="action is what action was taken/failed regarding to the regarding object. It is machine-readable. This field can have at most 128 characters.")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public V1beta1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1Event deprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecatedCount is the deprecated field assuring backward compatibility with core.v1 Event type.")
    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    public void setDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
    }

    public V1beta1Event deprecatedFirstTimestamp(OffsetDateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecatedFirstTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.")
    public OffsetDateTime getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    public void setDeprecatedFirstTimestamp(OffsetDateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
    }

    public V1beta1Event deprecatedLastTimestamp(OffsetDateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecatedLastTimestamp is the deprecated field assuring backward compatibility with core.v1 Event type.")
    public OffsetDateTime getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    public void setDeprecatedLastTimestamp(OffsetDateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
    }

    public V1beta1Event deprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EventSource getDeprecatedSource() {
        return this.deprecatedSource;
    }

    public void setDeprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
    }

    public V1beta1Event eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @ApiModelProperty(required=true, value="eventTime is the time when this Event was first observed. It is required.")
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public V1beta1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1Event note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="note is a human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public V1beta1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reason is why the action was taken. It is human-readable. This field can have at most 128 characters.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1beta1Event regarding(V1ObjectReference regarding) {
        this.regarding = regarding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getRegarding() {
        return this.regarding;
    }

    public void setRegarding(V1ObjectReference regarding) {
        this.regarding = regarding;
    }

    public V1beta1Event related(V1ObjectReference related) {
        this.related = related;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getRelated() {
        return this.related;
    }

    public void setRelated(V1ObjectReference related) {
        this.related = related;
    }

    public V1beta1Event reportingController(String reportingController) {
        this.reportingController = reportingController;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reportingController is the name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. This field cannot be empty for new Events.")
    public String getReportingController() {
        return this.reportingController;
    }

    public void setReportingController(String reportingController) {
        this.reportingController = reportingController;
    }

    public V1beta1Event reportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`. This field cannot be empty for new Events and it can have at most 128 characters.")
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public void setReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    public V1beta1Event series(V1beta1EventSeries series) {
        this.series = series;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1EventSeries getSeries() {
        return this.series;
    }

    public void setSeries(V1beta1EventSeries series) {
        this.series = series;
    }

    public V1beta1Event type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="type is the type of this event (Normal, Warning), new types could be added in the future. It is machine-readable.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Event v1beta1Event = (V1beta1Event)o;
        return Objects.equals(this.action, v1beta1Event.action) && Objects.equals(this.apiVersion, v1beta1Event.apiVersion) && Objects.equals(this.deprecatedCount, v1beta1Event.deprecatedCount) && Objects.equals(this.deprecatedFirstTimestamp, v1beta1Event.deprecatedFirstTimestamp) && Objects.equals(this.deprecatedLastTimestamp, v1beta1Event.deprecatedLastTimestamp) && Objects.equals(this.deprecatedSource, v1beta1Event.deprecatedSource) && Objects.equals(this.eventTime, v1beta1Event.eventTime) && Objects.equals(this.kind, v1beta1Event.kind) && Objects.equals(this.metadata, v1beta1Event.metadata) && Objects.equals(this.note, v1beta1Event.note) && Objects.equals(this.reason, v1beta1Event.reason) && Objects.equals(this.regarding, v1beta1Event.regarding) && Objects.equals(this.related, v1beta1Event.related) && Objects.equals(this.reportingController, v1beta1Event.reportingController) && Objects.equals(this.reportingInstance, v1beta1Event.reportingInstance) && Objects.equals(this.series, v1beta1Event.series) && Objects.equals(this.type, v1beta1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.deprecatedCount, this.deprecatedFirstTimestamp, this.deprecatedLastTimestamp, this.deprecatedSource, this.eventTime, this.kind, this.metadata, this.note, this.reason, this.regarding, this.related, this.reportingController, this.reportingInstance, this.series, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Event {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    deprecatedCount: ").append(this.toIndentedString(this.deprecatedCount)).append("\n");
        sb.append("    deprecatedFirstTimestamp: ").append(this.toIndentedString(this.deprecatedFirstTimestamp)).append("\n");
        sb.append("    deprecatedLastTimestamp: ").append(this.toIndentedString(this.deprecatedLastTimestamp)).append("\n");
        sb.append("    deprecatedSource: ").append(this.toIndentedString(this.deprecatedSource)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    regarding: ").append(this.toIndentedString(this.regarding)).append("\n");
        sb.append("    related: ").append(this.toIndentedString(this.related)).append("\n");
        sb.append("    reportingController: ").append(this.toIndentedString(this.reportingController)).append("\n");
        sb.append("    reportingInstance: ").append(this.toIndentedString(this.reportingInstance)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

