/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.utils;

import lombok.Generated;
import org.apache.dolphinscheduler.common.constants.TenantConstants;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.config.TenantConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantUtils.class);

    public static boolean isTenantEnable() {
        return OSUtils.isSudoEnable();
    }

    public static String getOrCreateActualTenant(WorkerConfig workerConfig, TaskExecutionContext taskExecutionContext) {
        TenantConfig tenantConfig = workerConfig.getTenantConfig();
        if (!TenantUtils.isTenantEnable()) {
            log.info("Tenant is not enabled, will use the bootstrap: {} user as tenant", (Object)TenantUtils.getBootstrapTenant());
            return TenantUtils.getBootstrapTenant();
        }
        String tenantCode = taskExecutionContext.getTenantCode();
        if (TenantUtils.isDefaultTenant(tenantCode)) {
            if (tenantConfig.isDefaultTenantEnabled()) {
                log.info("Current tenant is default tenant, will use bootstrap user: {} to execute the task", (Object)TenantUtils.getBootstrapTenant());
                return TenantUtils.getBootstrapTenant();
            }
            throw new TaskException("The tenantCode is " + tenantCode + ", please enable TenantConfig#isDefaultTenantEnabled");
        }
        if (tenantConfig.isAutoCreateTenantEnabled()) {
            OSUtils.createUserIfAbsent((String)tenantCode);
        }
        if (!TenantUtils.tenantExists(tenantCode)) {
            throw new TaskException(String.format("TenantCode: %s doesn't exist", tenantCode));
        }
        return tenantCode;
    }

    public static boolean isDefaultTenant(String tenantCode) {
        return "default".equals(tenantCode);
    }

    public static String getBootstrapTenant() {
        return TenantConstants.BOOTSTRAP_SYSTEM_USER;
    }

    public static boolean isBootstrapTenant(String tenantCode) {
        return TenantConstants.BOOTSTRAP_SYSTEM_USER.equals(tenantCode);
    }

    public static boolean tenantExists(String tenantCode) {
        return OSUtils.getUserList().contains(tenantCode);
    }

    @Generated
    private TenantUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

