/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.io.Files;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.AbstractResourceDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.IValidator;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractResourceValidator<T>
implements IValidator<T> {
    private static final Set<String> FILE_SUFFIXES_WHICH_CAN_FETCH_CONTENT = new HashSet<String>(Arrays.asList(((String)StringUtils.defaultIfBlank((CharSequence)FileUtils.getResourceViewSuffixes(), (CharSequence)"")).split(",")));
    protected final StorageOperator storageOperator;
    private final TenantDao tenantDao;

    public AbstractResourceValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        this.storageOperator = storageOperator;
        this.tenantDao = tenantDao;
    }

    public void exceptionResourceAbsolutePathInvalidated(String resourceAbsolutePath) {
        if (StringUtils.isBlank((CharSequence)resourceAbsolutePath)) {
            throw new ServiceException("The resource path is null");
        }
        if (!resourceAbsolutePath.startsWith(this.storageOperator.getStorageBaseDirectory())) {
            throw new ServiceException("Invalidated resource path: " + resourceAbsolutePath);
        }
        if (resourceAbsolutePath.contains("..")) {
            throw new ServiceException("Invalidated resource path: " + resourceAbsolutePath);
        }
    }

    public void exceptionFileInvalidated(MultipartFile file) {
        if (file == null) {
            throw new ServiceException("The file is null");
        }
    }

    public void exceptionFileContentInvalidated(String fileContent) {
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            throw new ServiceException("The file content is null");
        }
    }

    public void exceptionFileContentCannotFetch(String fileAbsolutePath) {
        String fileExtension = Files.getFileExtension((String)fileAbsolutePath);
        if (!FILE_SUFFIXES_WHICH_CAN_FETCH_CONTENT.contains(fileExtension)) {
            throw new ServiceException("The file type: " + fileExtension + " cannot be fetched");
        }
    }

    public void exceptionResourceNotExists(String resourceAbsolutePath) {
        if (!this.storageOperator.exists(resourceAbsolutePath)) {
            throw new ServiceException("Thr resource is not exists: " + resourceAbsolutePath);
        }
    }

    public void exceptionResourceExists(String resourceAbsolutePath) {
        if (this.storageOperator.exists(resourceAbsolutePath)) {
            throw new ServiceException("The resource is already exist: " + resourceAbsolutePath);
        }
    }

    public void exceptionResourceIsNotDirectory(String resourceAbsolutePath) {
        if (StringUtils.isNotEmpty((CharSequence)Files.getFileExtension((String)resourceAbsolutePath))) {
            throw new ServiceException("The path is not a directory: " + resourceAbsolutePath);
        }
    }

    public void exceptionResourceIsNotFile(String fileAbsolutePath) {
        if (StringUtils.isEmpty((CharSequence)Files.getFileExtension((String)fileAbsolutePath))) {
            throw new ServiceException("The path is not a file: " + fileAbsolutePath);
        }
    }

    public void exceptionUserNoResourcePermission(User user, AbstractResourceDto resourceDto) {
        this.exceptionUserNoResourcePermission(user, resourceDto.getResourceAbsolutePath());
    }

    public void exceptionUserNoResourcePermission(User user, String resourceAbsolutePath) {
        if (user.getUserType() == UserType.ADMIN_USER) {
            return;
        }
        ResourceMetadata resourceMetaData = this.storageOperator.getResourceMetaData(resourceAbsolutePath);
        if (!resourceAbsolutePath.startsWith(resourceMetaData.getResourceBaseDirectory())) {
            throw new ServiceException("Invalidated resource path: " + resourceAbsolutePath);
        }
        Tenant tenant = (Tenant)this.tenantDao.queryOptionalById((Serializable)Integer.valueOf(user.getTenantId())).orElseThrow(() -> new ServiceException(Status.TENANT_NOT_EXIST, user.getTenantId()));
        String userTenant = tenant.getTenantCode();
        if (!userTenant.equals(resourceMetaData.getTenant())) {
            throw new ServiceException("The user's tenant is " + userTenant + " have no permission to access the resource: " + resourceAbsolutePath);
        }
    }
}

