/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.common;

import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class CheckSumUtil {
    public static CheckSum makeCheckSum(CheckSumType checkSumType, byte[] input) throws KrbException {
        return CheckSumHandler.checksum((CheckSumType)checkSumType, (byte[])input);
    }

    public static CheckSum makeCheckSumWithKey(CheckSumType checkSumType, byte[] input, EncryptionKey key, KeyUsage usage) throws KrbException {
        EncTypeHandler handler;
        if ((checkSumType == null || checkSumType == CheckSumType.NONE) && (checkSumType = (handler = EncryptionHandler.getEncHandler((EncryptionType)key.getKeyType())).checksumType()) == null) {
            checkSumType = CheckSumType.CMAC_CAMELLIA128;
        }
        return CheckSumHandler.checksumWithKey((CheckSumType)checkSumType, (byte[])input, (byte[])key.getKeyData(), (KeyUsage)usage);
    }

    public static CheckSum seal(Asn1Encodeable asn1Object, CheckSumType checkSumType) throws KrbException {
        byte[] encoded = KrbCodec.encode((Asn1Type)asn1Object);
        CheckSum checksum = CheckSumUtil.makeCheckSum(checkSumType, encoded);
        return checksum;
    }

    public static CheckSum seal(Asn1Encodeable asn1Object, CheckSumType checkSumType, EncryptionKey key, KeyUsage usage) throws KrbException {
        byte[] encoded = KrbCodec.encode((Asn1Type)asn1Object);
        CheckSum checksum = CheckSumUtil.makeCheckSumWithKey(checkSumType, encoded, key, usage);
        return checksum;
    }
}

