/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TrimOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class RTrimOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("RTRIM").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).returnTypeCascadeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).requiredOperandCount(1).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            if (druidExpressions.size() > 1) {
                return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.TRAILING, (DruidExpression)druidExpressions.get(0), (DruidExpression)druidExpressions.get(1), Calcites.getColumnTypeForRelDataType(rexNode.getType()));
            }
            return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.TRAILING, (DruidExpression)druidExpressions.get(0), DruidExpression.ofStringLiteral(" "), Calcites.getColumnTypeForRelDataType(rexNode.getType()));
        });
    }
}

