/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import java.nio.charset.StandardCharsets;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class ObjectOrErrorResponseHandler<IntermediateType, FinalType>
implements HttpResponseHandler<Either<StringFullResponseHolder, IntermediateType>, Either<StringFullResponseHolder, FinalType>> {
    private final HttpResponseHandler<IntermediateType, FinalType> okHandler;
    private final StringFullResponseHandler errorHandler;

    public ObjectOrErrorResponseHandler(HttpResponseHandler<IntermediateType, FinalType> okHandler) {
        this.okHandler = okHandler;
        this.errorHandler = new StringFullResponseHandler(StandardCharsets.UTF_8);
    }

    @Override
    public ClientResponse<Either<StringFullResponseHolder, IntermediateType>> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        if (response.getStatus().getCode() / 100 == 2) {
            ClientResponse<IntermediateType> delegateResponse = this.okHandler.handleResponse(response, trafficCop);
            return new ClientResponse<Either<StringFullResponseHolder, IntermediateType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.value(delegateResponse.getObj()));
        }
        ClientResponse<StringFullResponseHolder> delegateResponse = this.errorHandler.handleResponse(response, trafficCop);
        return new ClientResponse<Either<StringFullResponseHolder, IntermediateType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.error(delegateResponse.getObj()));
    }

    @Override
    public ClientResponse<Either<StringFullResponseHolder, IntermediateType>> handleChunk(ClientResponse<Either<StringFullResponseHolder, IntermediateType>> clientResponse, HttpChunk chunk, long chunkNum) {
        Either<StringFullResponseHolder, IntermediateType> prevHolder = clientResponse.getObj();
        if (prevHolder.isValue()) {
            ClientResponse<IntermediateType> delegateResponse = this.okHandler.handleChunk(new ClientResponse<IntermediateType>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.valueOrThrow()), chunk, chunkNum);
            return new ClientResponse<Either<StringFullResponseHolder, IntermediateType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.value(delegateResponse.getObj()));
        }
        ClientResponse<StringFullResponseHolder> delegateResponse = this.errorHandler.handleChunk(new ClientResponse<StringFullResponseHolder>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.error()), chunk, chunkNum);
        return new ClientResponse<Either<StringFullResponseHolder, IntermediateType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.error(delegateResponse.getObj()));
    }

    @Override
    public ClientResponse<Either<StringFullResponseHolder, FinalType>> done(ClientResponse<Either<StringFullResponseHolder, IntermediateType>> clientResponse) {
        Either<StringFullResponseHolder, IntermediateType> prevHolder = clientResponse.getObj();
        if (prevHolder.isValue()) {
            ClientResponse<FinalType> delegateResponse = this.okHandler.done(new ClientResponse<IntermediateType>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.valueOrThrow()));
            return new ClientResponse<Either<StringFullResponseHolder, FinalType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.value(delegateResponse.getObj()));
        }
        ClientResponse<StringFullResponseHolder> delegateResponse = this.errorHandler.done(new ClientResponse<StringFullResponseHolder>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.error()));
        return new ClientResponse<Either<StringFullResponseHolder, FinalType>>(delegateResponse.isFinished(), delegateResponse.isContinueReading(), Either.error(delegateResponse.getObj()));
    }

    @Override
    public void exceptionCaught(ClientResponse<Either<StringFullResponseHolder, IntermediateType>> clientResponse, Throwable e) {
        Either<StringFullResponseHolder, IntermediateType> prevHolder = clientResponse.getObj();
        if (prevHolder.isValue()) {
            this.okHandler.exceptionCaught(new ClientResponse<IntermediateType>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.valueOrThrow()), e);
        } else {
            this.errorHandler.exceptionCaught(new ClientResponse<StringFullResponseHolder>(clientResponse.isFinished(), clientResponse.isContinueReading(), prevHolder.error()), e);
        }
    }
}

