/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

class ContainsExpr
extends ExprMacroTable.BaseScalarMacroFunctionExpr {
    private final Expr arg;
    private final Function<String, Boolean> searchFunction;

    ContainsExpr(ExprMacroTable.ExprMacro macro, Expr arg, Expr searchStrExpr, boolean caseSensitive) {
        this(macro, arg, searchStrExpr, ContainsExpr.createFunction(ContainsExpr.getSearchString(searchStrExpr, macro.name()), caseSensitive));
    }

    private ContainsExpr(ExprMacroTable.ExprMacro macro, Expr arg, Expr searchStrExpr, Function<String, Boolean> searchFunction) {
        super(macro, (List<Expr>)ImmutableList.of((Object)arg, (Object)searchStrExpr));
        this.arg = arg;
        this.searchFunction = searchFunction;
        ContainsExpr.getSearchString(searchStrExpr, macro.name());
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        String s = this.arg.eval(bindings).asString();
        if (s == null) {
            return ExprEval.ofLong(null);
        }
        boolean doesContain = this.searchFunction.apply(s);
        return ExprEval.ofLongBoolean(doesContain);
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return ExpressionType.LONG;
    }

    private static String getSearchString(Expr searchExpr, String functioName) {
        if (!ExprUtils.isStringLiteral(searchExpr)) {
            throw new IAE("Function[%s] substring must be a string literal", functioName);
        }
        return StringUtils.nullToEmptyNonDruidDataString((String)searchExpr.getLiteralValue());
    }

    private static Function<String, Boolean> createFunction(String searchString, boolean caseSensitive) {
        if (caseSensitive) {
            return s -> s.contains(searchString);
        }
        return s -> org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)searchString);
    }
}

