/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.timeline.partition.PartitionChunk;

public class NumberedOverwritingPartitionChunk<T>
implements PartitionChunk<T> {
    private final int chunkId;
    private final T object;

    public NumberedOverwritingPartitionChunk(int chunkId, T object) {
        Preconditions.checkArgument((chunkId >= 32768 && chunkId < 65536 ? 1 : 0) != 0, (String)"partitionNum[%s] >= %s && partitionNum[%s] < %s", (Object)chunkId, (Object)32768, (Object)chunkId, (Object)65536);
        this.chunkId = chunkId;
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean abuts(PartitionChunk<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStart() {
        return true;
    }

    @Override
    public boolean isEnd() {
        return true;
    }

    @Override
    public int getChunkNumber() {
        return this.chunkId;
    }

    @Override
    public int compareTo(PartitionChunk<T> o) {
        if (o instanceof NumberedOverwritingPartitionChunk) {
            NumberedOverwritingPartitionChunk that = (NumberedOverwritingPartitionChunk)o;
            return Integer.compare(this.chunkId, that.chunkId);
        }
        throw new IAE("Cannot compare against [%s]", o.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberedOverwritingPartitionChunk that = (NumberedOverwritingPartitionChunk)o;
        return this.chunkId == that.chunkId;
    }

    public int hashCode() {
        return Objects.hash(this.chunkId);
    }

    public String toString() {
        return "NumberedOverwritingPartitionChunk{chunkId=" + this.chunkId + ", object=" + this.object + "}";
    }
}

