/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.druid.metadata.PasswordProvider;

public class TLSServerConfig {
    @JsonProperty
    private String keyStorePath;
    @JsonProperty
    private String keyStoreType;
    @JsonProperty
    private String certAlias;
    @JsonProperty(value="keyStorePassword")
    private PasswordProvider keyStorePasswordProvider;
    @JsonProperty(value="keyManagerPassword")
    private PasswordProvider keyManagerPasswordProvider;
    @JsonProperty
    private String keyManagerFactoryAlgorithm;
    @JsonProperty
    private List<String> includeCipherSuites;
    @JsonProperty
    private List<String> excludeCipherSuites;
    @JsonProperty
    private List<String> includeProtocols;
    @JsonProperty
    private List<String> excludeProtocols;
    @JsonProperty
    private boolean requireClientCertificate = false;
    @JsonProperty
    private boolean requestClientCertificate = false;
    @JsonProperty
    private String trustStoreType;
    @JsonProperty
    private String trustStorePath;
    @JsonProperty
    private String trustStoreAlgorithm;
    @JsonProperty(value="trustStorePassword")
    private PasswordProvider trustStorePasswordProvider;
    @JsonProperty
    private boolean validateHostnames = true;
    @JsonProperty
    private String crlPath;
    @JsonProperty
    private boolean reloadSslContext = false;
    @JsonProperty
    private int reloadSslContextSeconds = 60;
    @JsonProperty
    private boolean forceApplyConfig = false;

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public PasswordProvider getKeyStorePasswordProvider() {
        return this.keyStorePasswordProvider;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public PasswordProvider getKeyManagerPasswordProvider() {
        return this.keyManagerPasswordProvider;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public List<String> getIncludeCipherSuites() {
        return this.includeCipherSuites;
    }

    public List<String> getExcludeCipherSuites() {
        return this.excludeCipherSuites;
    }

    public List<String> getIncludeProtocols() {
        return this.includeProtocols;
    }

    public List<String> getExcludeProtocols() {
        return this.excludeProtocols;
    }

    public boolean isRequireClientCertificate() {
        return this.requireClientCertificate;
    }

    public boolean isRequestClientCertificate() {
        return this.requestClientCertificate;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public PasswordProvider getTrustStorePasswordProvider() {
        return this.trustStorePasswordProvider;
    }

    public boolean isValidateHostnames() {
        return this.validateHostnames;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public int getReloadSslContextSeconds() {
        return this.reloadSslContextSeconds;
    }

    public boolean isReloadSslContext() {
        return this.reloadSslContext;
    }

    public boolean isForceApplyConfig() {
        return this.forceApplyConfig;
    }

    public String toString() {
        return "TLSServerConfig{keyStorePath='" + this.keyStorePath + "', keyStoreType='" + this.keyStoreType + "', certAlias='" + this.certAlias + "', keyManagerFactoryAlgorithm='" + this.keyManagerFactoryAlgorithm + "', includeCipherSuites=" + this.includeCipherSuites + ", excludeCipherSuites=" + this.excludeCipherSuites + ", includeProtocols=" + this.includeProtocols + ", excludeProtocols=" + this.excludeProtocols + ", requireClientCertificate=" + this.requireClientCertificate + ", requestClientCertificate=" + this.requestClientCertificate + ", trustStoreType='" + this.trustStoreType + "', trustStorePath='" + this.trustStorePath + "', trustStoreAlgorithm='" + this.trustStoreAlgorithm + "', validateHostnames='" + this.validateHostnames + "', crlPath='" + this.crlPath + "', reloadSslContext='" + this.reloadSslContext + "', reloadSslContextSeconds='" + this.reloadSslContextSeconds + "', forceApplyConfig=" + this.forceApplyConfig + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String keyStorePath;
        private String keyStoreType;
        private String certAlias;
        private PasswordProvider keyStorePasswordProvider;
        private PasswordProvider keyManagerPasswordProvider;
        private String keyManagerFactoryAlgorithm;
        private List<String> includeCipherSuites;
        private List<String> excludeCipherSuites;
        private List<String> includeProtocols;
        private List<String> excludeProtocols;
        private boolean requireClientCertificate = false;
        private boolean requestClientCertificate = false;
        private String trustStoreType;
        private String trustStorePath;
        private String trustStoreAlgorithm;
        private PasswordProvider trustStorePasswordProvider;
        private boolean validateHostnames = true;
        private String crlPath;
        private boolean reloadSslContext = false;
        private int reloadSslContextSeconds = 60;
        private boolean forceApplyConfig = false;

        public Builder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder certAlias(String certAlias) {
            this.certAlias = certAlias;
            return this;
        }

        public Builder keyStorePasswordProvider(PasswordProvider keyStorePasswordProvider) {
            this.keyStorePasswordProvider = keyStorePasswordProvider;
            return this;
        }

        public Builder keyManagerPasswordProvider(PasswordProvider keyManagerPasswordProvider) {
            this.keyManagerPasswordProvider = keyManagerPasswordProvider;
            return this;
        }

        public Builder keyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
            return this;
        }

        public Builder includeCipherSuites(List<String> includeCipherSuites) {
            this.includeCipherSuites = includeCipherSuites;
            return this;
        }

        public Builder excludeCipherSuites(List<String> excludeCipherSuites) {
            this.excludeCipherSuites = excludeCipherSuites;
            return this;
        }

        public Builder includeProtocols(List<String> includeProtocols) {
            this.includeProtocols = includeProtocols;
            return this;
        }

        public Builder excludeProtocols(List<String> excludeProtocols) {
            this.excludeProtocols = excludeProtocols;
            return this;
        }

        public Builder requireClientCertificate(boolean requireClientCertificate) {
            this.requireClientCertificate = requireClientCertificate;
            return this;
        }

        public Builder requestClientCertificate(boolean requestClientCertificate) {
            this.requestClientCertificate = requestClientCertificate;
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStoreAlgorithm(String trustStoreAlgorithm) {
            this.trustStoreAlgorithm = trustStoreAlgorithm;
            return this;
        }

        public Builder trustStorePasswordProvider(PasswordProvider trustStorePasswordProvider) {
            this.trustStorePasswordProvider = trustStorePasswordProvider;
            return this;
        }

        public Builder validateHostnames(boolean validateHostnames) {
            this.validateHostnames = validateHostnames;
            return this;
        }

        public Builder crlPath(String crlPath) {
            this.crlPath = crlPath;
            return this;
        }

        public Builder reloadSslContext(boolean reloadSslContext) {
            this.reloadSslContext = reloadSslContext;
            return this;
        }

        public Builder reloadSslContextSeconds(int reloadSslContextSeconds) {
            this.reloadSslContextSeconds = reloadSslContextSeconds;
            return this;
        }

        public Builder forceApplyConfig(boolean forceApplyConfig) {
            this.forceApplyConfig = forceApplyConfig;
            return this;
        }

        public TLSServerConfig build() {
            TLSServerConfig config = new TLSServerConfig();
            config.keyStorePath = this.keyStorePath;
            config.keyStoreType = this.keyStoreType;
            config.certAlias = this.certAlias;
            config.keyStorePasswordProvider = this.keyStorePasswordProvider;
            config.keyManagerPasswordProvider = this.keyManagerPasswordProvider;
            config.keyManagerFactoryAlgorithm = this.keyManagerFactoryAlgorithm;
            config.includeCipherSuites = this.includeCipherSuites;
            config.excludeCipherSuites = this.excludeCipherSuites;
            config.includeProtocols = this.includeProtocols;
            config.excludeProtocols = this.excludeProtocols;
            config.requireClientCertificate = this.requireClientCertificate;
            config.requestClientCertificate = this.requestClientCertificate;
            config.trustStoreType = this.trustStoreType;
            config.trustStorePath = this.trustStorePath;
            config.trustStoreAlgorithm = this.trustStoreAlgorithm;
            config.trustStorePasswordProvider = this.trustStorePasswordProvider;
            config.validateHostnames = this.validateHostnames;
            config.crlPath = this.crlPath;
            config.reloadSslContext = this.reloadSslContext;
            config.reloadSslContextSeconds = this.reloadSslContextSeconds;
            config.forceApplyConfig = this.forceApplyConfig;
            return config;
        }
    }
}

