/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.MetricsSystemConfiguration;
import org.apache.calcite.avatica.metrics.MetricsSystemFactory;
import org.apache.calcite.avatica.metrics.MetricsSystemLoader;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystemConfiguration;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaHandler;
import org.apache.calcite.avatica.server.AvaticaJsonHandler;
import org.apache.calcite.avatica.server.AvaticaProtobufHandler;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerFactory.class);

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization) {
        return this.getHandler(service, serialization, (MetricsSystemConfiguration<?>)NoopMetricsSystemConfiguration.getInstance());
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, AvaticaServerConfiguration serverConfig) {
        return this.getHandler(service, serialization, (MetricsSystemConfiguration<?>)NoopMetricsSystemConfiguration.getInstance(), serverConfig);
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, MetricsSystemConfiguration<?> metricsConfig) {
        return this.getHandler(service, serialization, metricsConfig, null);
    }

    public AvaticaHandler getHandler(Service service, Driver.Serialization serialization, MetricsSystemConfiguration<?> metricsConfig, AvaticaServerConfiguration serverConfig) {
        if (null == metricsConfig) {
            metricsConfig = NoopMetricsSystemConfiguration.getInstance();
        }
        MetricsSystem metrics = MetricsSystemLoader.load((MetricsSystemConfiguration)metricsConfig);
        switch (serialization) {
            case JSON: {
                return new AvaticaJsonHandler(service, metrics, serverConfig);
            }
            case PROTOBUF: {
                return new AvaticaProtobufHandler(service, metrics, serverConfig);
            }
        }
        throw new IllegalArgumentException("Unknown Avatica handler for " + serialization.name());
    }

    MetricsSystem loadMetricsSystem(MetricsSystemConfiguration<?> config) {
        ServiceLoader<MetricsSystemFactory> loader = ServiceLoader.load(MetricsSystemFactory.class);
        ArrayList<MetricsSystemFactory> availableFactories = new ArrayList<MetricsSystemFactory>();
        for (MetricsSystemFactory factory : loader) {
            availableFactories.add(factory);
        }
        if (1 == availableFactories.size()) {
            MetricsSystemFactory factory = (MetricsSystemFactory)availableFactories.get(0);
            LOG.info("Loaded MetricsSystem {}", factory.getClass());
            return factory.create(config);
        }
        if (availableFactories.isEmpty()) {
            LOG.info("No metrics implementation available on classpath. Using No-op implementation");
            return NoopMetricsSystem.getInstance();
        }
        StringBuilder sb = new StringBuilder();
        for (MetricsSystemFactory factory : availableFactories) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(factory.getClass());
        }
        LOG.warn("Found multiple MetricsSystemFactory implementations: {}. Using No-op implementation", (Object)sb);
        return NoopMetricsSystem.getInstance();
    }
}

