/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.joda.time.Interval;

public class TimeChunkLockTryAcquireAction
implements TaskAction<TaskLock> {
    private final TaskLockType type;
    private final Interval interval;

    @JsonCreator
    public TimeChunkLockTryAcquireAction(@JsonProperty(value="lockType") @Nullable TaskLockType type, @JsonProperty(value="interval") Interval interval) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.interval = interval;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        LockResult result = toolbox.getTaskLockbox().tryLock(task, new TimeChunkLockRequest(this.type, task, this.interval, null));
        return result.getTaskLock();
    }

    @Override
    public String toString() {
        return "TimeChunkLockTryAcquireAction{, type=" + this.type + ", interval=" + this.interval + "}";
    }
}

