/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.crypto.CryptoService;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;

public class Pac4jSessionStore
implements SessionStore {
    private static final Logger LOGGER = new Logger(Pac4jSessionStore.class);
    public static final String PAC4J_SESSION_PREFIX = "pac4j.session.";
    private final JEESessionStore delegate = JEESessionStore.INSTANCE;
    private final CryptoService cryptoService;

    public Pac4jSessionStore(String cookiePassphrase) {
        this.cryptoService = new CryptoService(cookiePassphrase, "AES", "CBC", "PKCS5Padding", "PBKDF2WithHmacSHA256", Integer.valueOf(128), Integer.valueOf(65536), Integer.valueOf(128));
    }

    public Optional<String> getSessionId(WebContext context, boolean createSession) {
        if (context instanceof JEEContext) {
            return this.delegate.getSessionId(context, createSession);
        }
        return Optional.empty();
    }

    public Optional<Object> get(WebContext context, String key) {
        javax.servlet.http.Cookie cookie = this.getCookie(context, PAC4J_SESSION_PREFIX + key);
        Serializable value = null;
        if (cookie != null && cookie.getValue() != null) {
            value = this.uncompressDecryptBase64(cookie.getValue());
        }
        return Optional.ofNullable(value);
    }

    public void set(WebContext context, String key, @Nullable Object value) {
        javax.servlet.http.Cookie cookie;
        boolean isEmpty;
        Object profile = value;
        boolean bl = isEmpty = value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty();
        if (isEmpty) {
            cookie = new javax.servlet.http.Cookie(PAC4J_SESSION_PREFIX + key, "");
            cookie.setMaxAge(0);
        } else {
            if ("pac4jUserProfiles".equals(key)) {
                profile = this.clearUserProfile(value);
            }
            String encryptedValue = this.compressEncryptBase64(profile);
            cookie = new javax.servlet.http.Cookie(PAC4J_SESSION_PREFIX + key, encryptedValue);
            cookie.setMaxAge(900);
        }
        cookie.setHttpOnly(true);
        boolean isSecure = this.isHttpsOrSecure(context);
        if (!isSecure) {
            LOGGER.warn("Setting authentication cookie over non-HTTPS connection. This is not recommended for production.", new Object[0]);
        }
        cookie.setSecure(true);
        cookie.setPath("/");
        if (context instanceof JEEContext) {
            JEEContext jeeContext = (JEEContext)context;
            HttpServletResponse response = jeeContext.getNativeResponse();
            response.addCookie(cookie);
            this.delegate.set(context, key, value);
        } else {
            Cookie pac4jCookie = new Cookie(cookie.getName(), cookie.getValue());
            pac4jCookie.setHttpOnly(cookie.isHttpOnly());
            pac4jCookie.setSecure(cookie.getSecure());
            pac4jCookie.setMaxAge(cookie.getMaxAge());
            pac4jCookie.setPath(cookie.getPath());
            if (cookie.getDomain() != null) {
                pac4jCookie.setDomain(cookie.getDomain());
            }
            context.addResponseCookie(pac4jCookie);
        }
    }

    public boolean destroySession(WebContext context) {
        if (context instanceof JEEContext) {
            return this.delegate.destroySession(context);
        }
        return false;
    }

    public Optional<Object> getTrackableSession(WebContext context) {
        if (context instanceof JEEContext) {
            return this.delegate.getTrackableSession(context);
        }
        return Optional.empty();
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        if (context instanceof JEEContext) {
            return this.delegate.buildFromTrackableSession(context, trackableSession);
        }
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        if (context instanceof JEEContext) {
            return this.delegate.renewSession(context);
        }
        return false;
    }

    @Nullable
    private String compressEncryptBase64(Object o) {
        if (o == null || "".equals(o) || o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        byte[] bytes = this.serializeToBytes((Serializable)o);
        if ((bytes = this.compress(bytes)).length > 3000) {
            LOGGER.warn("Cookie too big, it might not be properly set", new Object[0]);
        }
        return StringUtils.encodeBase64String((byte[])this.cryptoService.encrypt(bytes));
    }

    @Nullable
    private Serializable uncompressDecryptBase64(String v) {
        if (v != null && !v.isEmpty()) {
            try {
                byte[] bytes = StringUtils.decodeBase64String((String)v);
                if (bytes != null) {
                    return this.deserializeFromBytes(this.uncompress(this.cryptoService.decrypt(bytes)));
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to decrypt cookie value: %s", new Object[]{e.getMessage()});
                throw InvalidInput.exception((Throwable)e, (String)"Decryption failed. Check service logs.", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private byte[] compress(byte[] data) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);
        try {
            try (GZIPOutputStream gzip = new GZIPOutputStream(byteStream);){
                gzip.write(data);
            }
            byArray = byteStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Compression failed", ex);
            }
        }
        byteStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] uncompress(byte[] data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            byte[] byArray;
            try (GZIPInputStream gzip = new GZIPInputStream(inputStream);){
                byArray = ByteStreams.toByteArray((InputStream)gzip);
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("Decompression failed", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeToBytes(Serializable obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"Object to serialize cannot be null");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Serializable deserializeFromBytes(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"Data to deserialize cannot be null");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Serializable serializable;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                serializable = (Serializable)ois.readObject();
            }
            return serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize object", e);
        }
    }

    private Object clearUserProfile(Object value) {
        if (value instanceof Map) {
            Map profiles = (Map)value;
            profiles.forEach((name, profile) -> {
                if (profile != null) {
                    profile.removeAttribute("access_token");
                    profile.removeAttribute("refresh_token");
                    profile.removeAttribute("id_token");
                    profile.removeAttribute("credentials");
                }
            });
            return profiles;
        }
        if (value instanceof CommonProfile) {
            CommonProfile profile2 = (CommonProfile)value;
            profile2.removeAttribute("access_token");
            profile2.removeAttribute("refresh_token");
            profile2.removeAttribute("id_token");
            profile2.removeAttribute("credentials");
            return profile2;
        }
        return value;
    }

    private javax.servlet.http.Cookie getCookie(WebContext context, String name) {
        block6: {
            Collection requestCookies;
            block5: {
                if (!(context instanceof JEEContext)) break block5;
                JEEContext jeeContext = (JEEContext)context;
                HttpServletRequest request = jeeContext.getNativeRequest();
                javax.servlet.http.Cookie[] cookies = request.getCookies();
                if (cookies == null) break block6;
                for (javax.servlet.http.Cookie cookie : cookies) {
                    if (!name.equals(cookie.getName())) continue;
                    return cookie;
                }
                break block6;
            }
            if (context != null && (requestCookies = context.getRequestCookies()) != null) {
                for (Cookie cookie : requestCookies) {
                    if (!name.equals(cookie.getName())) continue;
                    javax.servlet.http.Cookie servletCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
                    servletCookie.setHttpOnly(cookie.isHttpOnly());
                    servletCookie.setSecure(cookie.isSecure());
                    servletCookie.setMaxAge(cookie.getMaxAge());
                    if (cookie.getPath() != null) {
                        servletCookie.setPath(cookie.getPath());
                    }
                    if (cookie.getDomain() != null) {
                        servletCookie.setDomain(cookie.getDomain());
                    }
                    return servletCookie;
                }
            }
        }
        return null;
    }

    private boolean isHttpsOrSecure(WebContext context) {
        if (context instanceof JEEContext) {
            JEEContext jeeContext = (JEEContext)context;
            HttpServletRequest request = jeeContext.getNativeRequest();
            return request.isSecure() || "https".equalsIgnoreCase(request.getScheme()) || "https".equalsIgnoreCase(request.getHeader("X-Forwarded-Proto"));
        }
        return "https".equalsIgnoreCase(context.getScheme());
    }
}

