/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.navercorp.pinpoint.grpc.trace.PMonitorInfo;
import com.navercorp.pinpoint.grpc.trace.PThreadDump;
import com.navercorp.pinpoint.grpc.trace.PThreadState;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcThreadStateMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.MonitorInfoMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;

public class GrpcThreadDumpMessageConverter
implements MessageConverter<Object, PThreadDump> {
    private final GrpcThreadStateMessageConverter threadStateMessageConverter = new GrpcThreadStateMessageConverter();

    @Override
    public PThreadDump toMessage(Object message) {
        if (message instanceof ThreadDumpMetricSnapshot) {
            ThreadDumpMetricSnapshot threadDumpMetricSnapshot = (ThreadDumpMetricSnapshot)message;
            PThreadDump.Builder threadDumpBuilder = PThreadDump.newBuilder();
            threadDumpBuilder.setThreadName(threadDumpMetricSnapshot.getThreadName());
            threadDumpBuilder.setThreadId(threadDumpMetricSnapshot.getThreadId());
            threadDumpBuilder.setBlockedTime(threadDumpMetricSnapshot.getBlockedTime());
            threadDumpBuilder.setBlockedCount(threadDumpMetricSnapshot.getBlockedCount());
            threadDumpBuilder.setWaitedTime(threadDumpMetricSnapshot.getWaitedTime());
            threadDumpBuilder.setWaitedCount(threadDumpMetricSnapshot.getWaitedCount());
            threadDumpBuilder.setInNative(threadDumpMetricSnapshot.isInNative());
            threadDumpBuilder.setSuspended(threadDumpMetricSnapshot.isSuspended());
            PThreadState threadState = this.threadStateMessageConverter.toMessage((Object)threadDumpMetricSnapshot.getThreadState());
            threadDumpBuilder.setThreadState(threadState);
            for (String stackTrace : threadDumpMetricSnapshot.getStackTrace()) {
                threadDumpBuilder.addStackTrace(stackTrace);
            }
            for (MonitorInfoMetricSnapshot monitorInfoMetricSnapshot : threadDumpMetricSnapshot.getLockedMonitors()) {
                PMonitorInfo.Builder monitorInfoBuilder = PMonitorInfo.newBuilder();
                monitorInfoBuilder.setStackDepth(monitorInfoMetricSnapshot.getStackDepth());
                monitorInfoBuilder.setStackFrame(monitorInfoMetricSnapshot.getStackFrame());
                threadDumpBuilder.addLockedMonitor(monitorInfoBuilder.build());
            }
            if (threadDumpMetricSnapshot.getLockName() != null) {
                threadDumpBuilder.setLockName(threadDumpMetricSnapshot.getLockName());
            }
            threadDumpBuilder.setLockOwnerId(threadDumpMetricSnapshot.getLockOwnerId());
            if (threadDumpMetricSnapshot.getLockOwnerName() != null) {
                threadDumpBuilder.setLockOwnerName(threadDumpMetricSnapshot.getLockOwnerName());
            }
            for (String lockedSynchronizer : threadDumpMetricSnapshot.getLockedSynchronizers()) {
                threadDumpBuilder.addLockedSynchronizer(lockedSynchronizer);
            }
            return threadDumpBuilder.build();
        }
        return null;
    }
}

