/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.plugin;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.profiler.trace.AnnotationKeyMatcherRegistry;
import com.navercorp.pinpoint.common.profiler.trace.AnnotationKeyRegistry;
import com.navercorp.pinpoint.common.profiler.trace.ServiceTypeRegistry;
import com.navercorp.pinpoint.common.profiler.trace.TraceMetadataLoader;
import com.navercorp.pinpoint.common.profiler.trace.TraceMetadataRegistrar;
import com.navercorp.pinpoint.common.trace.AnnotationKeyLocator;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcherLocator;
import com.navercorp.pinpoint.common.trace.ServiceTypeLocator;
import com.navercorp.pinpoint.loader.service.TraceMetadataLoaderService;
import com.navercorp.pinpoint.profiler.metadata.DefaultTraceMetadataLoaderService;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceMetadataLoaderServiceProvider
implements Provider<TraceMetadataLoaderService> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ServiceTypeRegistry serviceTypeRegistry;
    private final AnnotationKeyRegistry annotationKeyRegistry;
    private final AnnotationKeyMatcherRegistry annotationKeyMatcherRegistry;

    @Inject
    public TraceMetadataLoaderServiceProvider(TraceMetadataLoader traceMetadataLoader) {
        Objects.requireNonNull(traceMetadataLoader, "traceMetadataLoader");
        this.serviceTypeRegistry = traceMetadataLoader.createServiceTypeRegistry();
        this.annotationKeyRegistry = traceMetadataLoader.createAnnotationKeyRegistry();
        this.annotationKeyMatcherRegistry = traceMetadataLoader.createAnnotationKeyMatcherRegistry();
    }

    public TraceMetadataLoaderService get() {
        this.logger.info("Registering trace metadata to providers");
        TraceMetadataRegistrar.registerServiceTypes((ServiceTypeLocator)this.serviceTypeRegistry);
        TraceMetadataRegistrar.registerAnnotationKeys((AnnotationKeyLocator)this.annotationKeyRegistry);
        return new DefaultTraceMetadataLoaderService((ServiceTypeLocator)this.serviceTypeRegistry, (AnnotationKeyLocator)this.annotationKeyRegistry, (AnnotationKeyMatcherLocator)this.annotationKeyMatcherRegistry);
    }
}

