/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.UnsupportedMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.datasource.DefaultDataSourceMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import java.util.Objects;

public class DataSourceMetricCollectorProvider
implements Provider<AgentStatMetricCollector<DataSourceMetricSnapshot>> {
    private final DataSourceMetric dataSourceMetric;

    @Inject
    public DataSourceMetricCollectorProvider(DataSourceMetric dataSourceMetric) {
        this.dataSourceMetric = Objects.requireNonNull(dataSourceMetric, "dataSourceMetric");
    }

    public AgentStatMetricCollector<DataSourceMetricSnapshot> get() {
        if (this.dataSourceMetric == DataSourceMetric.UNSUPPORTED_DATA_SOURCE_METRIC) {
            return new UnsupportedMetricCollector<DataSourceMetricSnapshot>();
        }
        return new DefaultDataSourceMetricCollector(this.dataSourceMetric);
    }
}

