/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.uri;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.EachUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AgentUriStatData
implements MetricType {
    private final long baseTimestamp;
    private final Map<String, EachUriStatData> eachUriStatDataMap = new HashMap<String, EachUriStatData>();

    public AgentUriStatData(long baseTimestamp) {
        Assert.isTrue((baseTimestamp > 0L ? 1 : 0) != 0, (String)"baseTimestamp must be  ` > 0`");
        this.baseTimestamp = baseTimestamp;
    }

    public long getBaseTimestamp() {
        return this.baseTimestamp;
    }

    public void add(UriStatInfo uriStatInfo) {
        String uri = uriStatInfo.getUri();
        EachUriStatData eachUriStatData = this.eachUriStatDataMap.get(uri);
        if (eachUriStatData == null) {
            eachUriStatData = new EachUriStatData(uri);
            this.eachUriStatDataMap.put(uri, eachUriStatData);
        }
        eachUriStatData.add(uriStatInfo);
    }

    public Collection<EachUriStatData> getAllUriStatData() {
        return this.eachUriStatDataMap.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgentUriStatData{");
        sb.append("baseTimestamp=").append(this.baseTimestamp);
        sb.append(", eachUriStatDataMap=").append(this.eachUriStatDataMap);
        sb.append('}');
        return sb.toString();
    }
}

