/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.profiler.sender.grpc.StreamState;

public class SimpleStreamState
implements StreamState {
    private final int limitCount;
    private final long limitTime;
    private long failCount = 0L;
    private long failureTime = 0L;

    public SimpleStreamState(int limitCount, long limitTime) {
        this.limitCount = limitCount;
        this.limitTime = limitTime;
    }

    @Override
    public void fail() {
        if (this.failureTime == 0L) {
            this.failureTime = System.currentTimeMillis();
        }
        ++this.failCount;
    }

    @Override
    public boolean isFailure() {
        long errorDuration = System.currentTimeMillis() - this.failureTime;
        return errorDuration > this.limitTime && this.failCount > (long)this.limitCount;
    }

    @Override
    public void success() {
        this.failureTime = 0L;
        this.failCount = 0L;
    }

    public String toString() {
        return "SimpleStreamState{limitCount=" + this.limitCount + ", limitTime=" + this.limitTime + ", failCount=" + this.failCount + ", failureTime=" + this.failureTime + '}';
    }
}

