/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import java.lang.instrument.ClassFileTransformer;
import java.util.Objects;

public class DelegateTransformerRegistry
implements TransformerRegistry {
    private final TransformerRegistry transformerRegistry;
    private final TransformerRegistry debugTransformerRegistry;

    public DelegateTransformerRegistry(TransformerRegistry transformerRegistry, TransformerRegistry debugTransformerRegistry) {
        this.transformerRegistry = Objects.requireNonNull(transformerRegistry, "transformerRegistry");
        this.debugTransformerRegistry = Objects.requireNonNull(debugTransformerRegistry, "debugTransformerRegistry");
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer) {
        ClassFileTransformer transformer = this.transformerRegistry.findTransformer(classLoader, classInternalName, classFileBuffer);
        if (transformer != null) {
            return transformer;
        }
        ClassFileTransformer debugTransformer = this.debugTransformerRegistry.findTransformer(classLoader, classInternalName, classFileBuffer);
        if (debugTransformer != null) {
            return debugTransformer;
        }
        return null;
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer, InternalClassMetadata classMetadata) {
        ClassFileTransformer transformer = this.transformerRegistry.findTransformer(classLoader, classInternalName, classFileBuffer, classMetadata);
        if (transformer != null) {
            return transformer;
        }
        ClassFileTransformer debugTransformer = this.debugTransformerRegistry.findTransformer(classLoader, classInternalName, classFileBuffer, classMetadata);
        if (debugTransformer != null) {
            return debugTransformer;
        }
        return null;
    }
}

