/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandshaker;
import com.navercorp.pinpoint.rpc.client.SocketIdFactory;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.netty.util.Timer;

public class HandshakerFactory {
    public static final String SOCKET_ID = "socketId";
    private static final int DEFAULT_ENABLE_WORKER_PACKET_RETRY_COUNT = Integer.MAX_VALUE;
    private final int maxHandshakeCount = Integer.MAX_VALUE;
    private final SocketIdFactory socketIdFactory;
    private final Map<String, Object> properties;
    private final ClusterOption clusterOption;
    private final ClientOption clientOption;

    public HandshakerFactory(SocketIdFactory socketIdFactory, Map<String, Object> properties, ClientOption clientOption, ClusterOption clusterOption) {
        this.socketIdFactory = Objects.requireNonNull(socketIdFactory, SOCKET_ID);
        this.clusterOption = Objects.requireNonNull(clusterOption, "clusterOption");
        this.clientOption = Objects.requireNonNull(clientOption, "clientOption");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public PinpointClientHandshaker newHandShaker(Timer channelTimer) {
        Map<String, Object> handshakeData = this.createHandShakeData();
        return new PinpointClientHandshaker(handshakeData, channelTimer, this.clientOption.getEnableWorkerPacketDelay(), Integer.MAX_VALUE);
    }

    private Map<String, Object> createHandShakeData() {
        HashMap<String, Object> handshakeData = new HashMap<String, Object>(this.properties);
        int socketId = this.socketIdFactory.nextSocketId();
        handshakeData.put(SOCKET_ID, socketId);
        if (this.clusterOption.isEnable()) {
            handshakeData.put("cluster", this.clusterOption.toMap());
        }
        return handshakeData;
    }
}

