/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.client;

import com.google.protobuf.Timestamp;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.connector.openfunction.client.CallbackServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackService
extends CallbackServiceGrpc.CallbackServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(CallbackService.class);

    @Override
    public void onTopicEvent(CloudEvent cloudEvent, StreamObserver<CloudEvent> responseObserver) {
        log.info("cloudevents: {}|data: {}", (Object)cloudEvent, (Object)cloudEvent.getTextData());
        Instant instant = CallbackService.now();
        CloudEvent.Builder builder = CloudEvent.newBuilder();
        builder.putAttributes("statuscode", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.SUCCESS.getRetCode()).build()).putAttributes("responsemessage", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(StatusCode.SUCCESS.getErrMsg()).build()).putAttributes("time", CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build());
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    private static Instant now() {
        return OffsetDateTime.of(LocalDateTime.now(ZoneId.systemDefault()), ZoneOffset.UTC).toInstant();
    }
}

