/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.source.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.openfunction.source.config.OpenFunctionSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFunctionSourceConnector
implements Source {
    private static final Logger log = LoggerFactory.getLogger(OpenFunctionSourceConnector.class);
    private static final int DEFAULT_BATCH_SIZE = 10;
    private OpenFunctionSourceConfig sourceConfig;
    private BlockingQueue<ConnectRecord> queue;

    public Class<? extends Config> configClass() {
        return OpenFunctionSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (OpenFunctionSourceConfig)config;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (OpenFunctionSourceConfig)sourceConnectorContext.getSourceConfig();
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getSourceConnectorConfig().getConnectorName();
    }

    public void stop() {
    }

    public BlockingQueue<ConnectRecord> queue() {
        return this.queue;
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(10);
        for (int count = 0; count < 10; ++count) {
            try {
                ConnectRecord connectRecord = this.queue.poll(3L, TimeUnit.SECONDS);
                if (connectRecord == null) break;
                connectRecords.add(connectRecord);
                continue;
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[OpenFunctionSourceConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
        }
        return connectRecords;
    }
}

