/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.source.connector;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqClient;
import org.apache.eventmesh.connector.rabbitmq.client.RabbitmqConnectionFactory;
import org.apache.eventmesh.connector.rabbitmq.cloudevent.RabbitmqCloudEvent;
import org.apache.eventmesh.connector.rabbitmq.source.config.RabbitMQSourceConfig;
import org.apache.eventmesh.connector.rabbitmq.source.config.SourceConnectorConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQSourceConnector
implements Source {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQSourceConnector.class);
    private RabbitMQSourceConfig sourceConfig;
    private volatile boolean started = false;
    private static final int DEFAULT_BATCH_SIZE = 10;
    private BlockingQueue<CloudEvent> queue;
    private final RabbitmqConnectionFactory rabbitmqConnectionFactory = new RabbitmqConnectionFactory();
    private RabbitMQSourceHandler rabbitMQSourceHandler;
    private RabbitmqClient rabbitmqClient;
    private Connection connection;
    private Channel channel;
    private final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-RabbitMQSourceConnector-");

    public Class<? extends Config> configClass() {
        return RabbitMQSourceConfig.class;
    }

    public void init(Config config) throws Exception {
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        this.queue = new LinkedBlockingQueue<CloudEvent>(1000);
        this.sourceConfig = (RabbitMQSourceConfig)((SourceConnectorContext)connectorContext).getSourceConfig();
        this.rabbitmqClient = new RabbitmqClient(this.rabbitmqConnectionFactory);
        this.connection = this.rabbitmqClient.getConnection(this.sourceConfig.getConnectorConfig().getHost(), this.sourceConfig.getConnectorConfig().getUsername(), this.sourceConfig.getConnectorConfig().getPasswd(), this.sourceConfig.getConnectorConfig().getPort(), this.sourceConfig.getConnectorConfig().getVirtualHost());
        this.channel = this.rabbitmqConnectionFactory.createChannel(this.connection);
        this.rabbitMQSourceHandler = new RabbitMQSourceHandler(this.channel, this.sourceConfig.getConnectorConfig());
    }

    public void start() throws Exception {
        if (!this.started) {
            this.rabbitmqClient.binding(this.channel, this.sourceConfig.getConnectorConfig().getExchangeType(), this.sourceConfig.getConnectorConfig().getExchangeName(), this.sourceConfig.getConnectorConfig().getRoutingKey(), this.sourceConfig.getConnectorConfig().getQueueName());
            this.executor.execute(this.rabbitMQSourceHandler);
            this.started = true;
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        if (this.started) {
            try {
                this.rabbitmqClient.unbinding(this.channel, this.sourceConfig.getConnectorConfig().getExchangeName(), this.sourceConfig.getConnectorConfig().getRoutingKey(), this.sourceConfig.getConnectorConfig().getQueueName());
                this.rabbitmqClient.closeConnection(this.connection);
                this.rabbitmqClient.closeChannel(this.channel);
                this.rabbitMQSourceHandler.stop();
            }
            finally {
                this.started = false;
            }
        }
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(10);
        for (int count = 0; count < 10; ++count) {
            try {
                CloudEvent event = this.queue.poll(3L, TimeUnit.SECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }

    public class RabbitMQSourceHandler
    implements Runnable {
        private final Channel channel;
        private final SourceConnectorConfig connectorConfig;
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public RabbitMQSourceHandler(Channel channel, SourceConnectorConfig connectorConfig) {
            this.channel = channel;
            this.connectorConfig = connectorConfig;
        }

        @Override
        public void run() {
            while (!this.stop.get()) {
                try {
                    GetResponse response = this.channel.basicGet(this.connectorConfig.getQueueName(), this.connectorConfig.isAutoAck());
                    if (response == null) continue;
                    RabbitmqCloudEvent rabbitmqCloudEvent = RabbitmqCloudEvent.getFromByteArray(response.getBody());
                    CloudEvent event = rabbitmqCloudEvent.convertToCloudEvent();
                    if (event != null) {
                        RabbitMQSourceConnector.this.queue.add(event);
                    }
                    if (this.connectorConfig.isAutoAck()) continue;
                    this.channel.basicAck(response.getEnvelope().getDeliveryTag(), false);
                }
                catch (Exception ex) {
                    log.error("[RabbitMQSourceHandler] thread run happen exception.", (Throwable)ex);
                }
            }
        }

        public void stop() {
            this.stop.compareAndSet(false, true);
        }
    }
}

