/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactory;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.SslOption;
import com.navercorp.pinpoint.grpc.security.SslClientConfig;
import com.navercorp.pinpoint.grpc.util.Resource;
import io.grpc.ClientInterceptor;
import io.grpc.NameResolverProvider;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultChannelFactoryBuilder
implements ChannelFactoryBuilder {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String factoryName;
    private int executorQueueSize = 1024;
    private HeaderFactory headerFactory;
    private ClientOption clientOption;
    private SslOption sslOption;
    private final LinkedList<ClientInterceptor> clientInterceptorList = new LinkedList();
    private NameResolverProvider nameResolverProvider;

    public DefaultChannelFactoryBuilder(String factoryName) {
        this.factoryName = Objects.requireNonNull(factoryName, "factoryName");
    }

    @Override
    public void setExecutorQueueSize(int executorQueueSize) {
        Assert.isTrue((executorQueueSize > 0 ? 1 : 0) != 0, (String)"must be `executorQueueSize > 0`");
        this.executorQueueSize = executorQueueSize;
    }

    @Override
    public void setHeaderFactory(HeaderFactory headerFactory) {
        this.headerFactory = Objects.requireNonNull(headerFactory, "headerFactory");
    }

    @Override
    public void addFirstClientInterceptor(ClientInterceptor clientInterceptor) {
        Objects.requireNonNull(clientInterceptor, "clientInterceptor");
        this.clientInterceptorList.addFirst(clientInterceptor);
    }

    @Override
    public void addClientInterceptor(ClientInterceptor clientInterceptor) {
        Objects.requireNonNull(clientInterceptor, "clientInterceptor");
        this.clientInterceptorList.add(clientInterceptor);
    }

    @Override
    public void setClientOption(ClientOption clientOption) {
        this.clientOption = Objects.requireNonNull(clientOption, "clientOption");
    }

    @Override
    public void setSslOption(SslOption sslOption) {
        this.sslOption = sslOption;
    }

    @Override
    public void setNameResolverProvider(NameResolverProvider nameResolverProvider) {
        this.nameResolverProvider = Objects.requireNonNull(nameResolverProvider, "nameResolverProvider");
    }

    @Override
    public ChannelFactory build() {
        this.logger.info("build ChannelFactory:{}", (Object)this.factoryName);
        Objects.requireNonNull(this.headerFactory, "headerFactory");
        Objects.requireNonNull(this.clientOption, "clientOption");
        SslClientConfig sslClientConfig = SslClientConfig.DISABLED_CONFIG;
        if (this.sslOption != null && this.sslOption.isEnable()) {
            String providerType = this.sslOption.getProviderType();
            Resource trustCertResource = this.sslOption.getTrustCertResource();
            sslClientConfig = new SslClientConfig(true, providerType, trustCertResource);
        }
        return new DefaultChannelFactory(this.factoryName, this.executorQueueSize, this.headerFactory, this.nameResolverProvider, this.clientOption, sslClientConfig, this.clientInterceptorList);
    }
}

