/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.grpc.ChannelTypeEnum;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ServerOption {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    public static final long DEFAULT_KEEPALIVE_TIME = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_KEEPALIVE_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    public static final long DEFAULT_PERMIT_KEEPALIVE_TIME = TimeUnit.SECONDS.toMillis(20L);
    public static final boolean PERMIT_KEEPALIVE_WITHOUT_CALLS_DISABLE = Boolean.FALSE;
    public static final long DEFAULT_MAX_CONNECTION_IDLE = TimeUnit.SECONDS.toMillis(10L);
    public static final long DEFAULT_MAX_CONNECTION_AGE = Long.MAX_VALUE;
    public static final long DEFAULT_MAX_CONNECTION_AGE_GRACE = Long.MAX_VALUE;
    public static final int DEFAULT_MAX_CONCURRENT_CALLS_PER_CONNECTION = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_INBOUND_MESSAGE_SIZE = 0x400000;
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = 8192;
    public static final long DEFAULT_HANDSHAKE_TIMEOUT = TimeUnit.SECONDS.toMillis(120L);
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    public static final String DEFAULT_CHANNEL_TYPE = ChannelTypeEnum.AUTO.name();
    private final long keepAliveTime;
    private final long keepAliveTimeout;
    private final long permitKeepAliveTime;
    private final boolean permitKeepAliveWithoutCalls = PERMIT_KEEPALIVE_WITHOUT_CALLS_DISABLE;
    private final long maxConnectionIdle;
    private final long maxConnectionAge = Long.MAX_VALUE;
    private final long maxConnectionAgeGrace = Long.MAX_VALUE;
    private final int maxConcurrentCallsPerConnection;
    private final int maxInboundMessageSize;
    private final int maxHeaderListSize;
    private final long handshakeTimeout;
    private final int flowControlWindow;
    private final int receiveBufferSize;
    public final ChannelTypeEnum channelTypeEnum;

    ServerOption(long keepAliveTime, long keepAliveTimeout, long permitKeepAliveTime, long maxConnectionIdle, int maxConcurrentCallsPerConnection, int maxInboundMessageSize, int maxHeaderListSize, long handshakeTimeout, int flowControlWindow, int receiveBufferSize, ChannelTypeEnum channelTypeEnum) {
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeout = keepAliveTimeout;
        this.permitKeepAliveTime = permitKeepAliveTime;
        this.maxConnectionIdle = maxConnectionIdle;
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.handshakeTimeout = handshakeTimeout;
        this.flowControlWindow = flowControlWindow;
        this.receiveBufferSize = receiveBufferSize;
        this.channelTypeEnum = Objects.requireNonNull(channelTypeEnum, "channelTypeEnum");
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public long getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public long getMaxConnectionIdle() {
        return this.maxConnectionIdle;
    }

    public long getMaxConnectionAge() {
        return Long.MAX_VALUE;
    }

    public long getMaxConnectionAgeGrace() {
        return Long.MAX_VALUE;
    }

    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public ChannelTypeEnum getChannelTypeEnum() {
        return this.channelTypeEnum;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServerOption{");
        sb.append("keepAliveTime=").append(this.keepAliveTime);
        sb.append(", keepAliveTimeout=").append(this.keepAliveTimeout);
        sb.append(", permitKeepAliveTime=").append(this.permitKeepAliveTime);
        sb.append(", permitKeepAliveWithoutCalls=").append(this.permitKeepAliveWithoutCalls);
        sb.append(", maxConnectionIdle=").append(this.maxConnectionIdle);
        sb.append(", maxConnectionAge=").append(Long.MAX_VALUE);
        sb.append(", maxConnectionAgeGrace=").append(Long.MAX_VALUE);
        sb.append(", maxConcurrentCallsPerConnection=").append(this.maxConcurrentCallsPerConnection);
        sb.append(", maxInboundMessageSize=").append(this.maxInboundMessageSize);
        sb.append(", maxHeaderListSize=").append(this.maxHeaderListSize);
        sb.append(", handshakeTimeout=").append(this.handshakeTimeout);
        sb.append(", flowControlWindow=").append(this.flowControlWindow);
        sb.append(", receiveBufferSize=").append(this.receiveBufferSize);
        sb.append(", channelTypeEnum=").append((Object)this.channelTypeEnum);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private long keepAliveTime = DEFAULT_KEEPALIVE_TIME;
        private long keepAliveTimeout = DEFAULT_KEEPALIVE_TIMEOUT;
        private long permitKeepAliveTime = DEFAULT_PERMIT_KEEPALIVE_TIME;
        private long maxConnectionIdle = DEFAULT_MAX_CONNECTION_IDLE;
        private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
        private int maxInboundMessageSize = 0x400000;
        private int maxHeaderListSize = 8192;
        private long handshakeTimeout = DEFAULT_HANDSHAKE_TIMEOUT;
        private int flowControlWindow = 0x100000;
        private int receiveBufferSize = 65536;
        private ChannelTypeEnum channelTypeEnum = ChannelTypeEnum.valueOf(DEFAULT_CHANNEL_TYPE);

        private Builder() {
        }

        public ServerOption build() {
            ServerOption serverOption = new ServerOption(this.keepAliveTime, this.keepAliveTimeout, this.permitKeepAliveTime, this.maxConnectionIdle, this.maxConcurrentCallsPerConnection, this.maxInboundMessageSize, this.maxHeaderListSize, this.handshakeTimeout, this.flowControlWindow, this.receiveBufferSize, this.channelTypeEnum);
            return serverOption;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            Assert.isTrue((keepAliveTime > 0L ? 1 : 0) != 0, (String)("keepAliveTime " + keepAliveTime + " must be positive"));
            this.keepAliveTime = keepAliveTime;
        }

        public void setKeepAliveTimeout(long keepAliveTimeout) {
            Assert.isTrue((keepAliveTimeout > 0L ? 1 : 0) != 0, (String)("keepAliveTimeout " + keepAliveTimeout + " must be positive"));
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public void setPermitKeepAliveTime(long permitKeepAliveTime) {
            Assert.isTrue((permitKeepAliveTime >= 0L ? 1 : 0) != 0, (String)("permitKeepAliveTime " + permitKeepAliveTime + " must be non-negative"));
            this.permitKeepAliveTime = permitKeepAliveTime;
        }

        public void setMaxConnectionIdle(long maxConnectionIdle) {
            Assert.isTrue((maxConnectionIdle > 0L ? 1 : 0) != 0, (String)("maxConnectionIdle " + maxConnectionIdle + " must be positive"));
            this.maxConnectionIdle = maxConnectionIdle;
        }

        public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
            Assert.isTrue((maxConcurrentCallsPerConnection > 0 ? 1 : 0) != 0, (String)("maxConcurrentCallsPerConnection " + maxConcurrentCallsPerConnection + " must be positive"));
            this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
        }

        public void setMaxInboundMessageSize(int maxInboundMessageSize) {
            Assert.isTrue((maxInboundMessageSize > 0 ? 1 : 0) != 0, (String)("maxInboundMessageSize " + maxInboundMessageSize + " must be positive"));
            this.maxInboundMessageSize = maxInboundMessageSize;
        }

        public void setMaxHeaderListSize(int maxHeaderListSize) {
            Assert.isTrue((maxHeaderListSize > 0 ? 1 : 0) != 0, (String)("maxHeaderListSize " + maxHeaderListSize + " must be positive"));
            this.maxHeaderListSize = maxHeaderListSize;
        }

        public void setHandshakeTimeout(long handshakeTimeout) {
            Assert.isTrue((handshakeTimeout > 0L ? 1 : 0) != 0, (String)("handshakeTimeout " + handshakeTimeout + " must be positive"));
            this.handshakeTimeout = handshakeTimeout;
        }

        public void setFlowControlWindow(int flowControlWindow) {
            Assert.isTrue((flowControlWindow > 0 ? 1 : 0) != 0, (String)("flowControlWindow " + flowControlWindow + " must be positive"));
            this.flowControlWindow = flowControlWindow;
        }

        public void setReceiveBufferSize(int receiveBufferSize) {
            Assert.isTrue((receiveBufferSize > 0 ? 1 : 0) != 0, (String)("receiveBufferSize " + receiveBufferSize + " must be positive"));
            this.receiveBufferSize = receiveBufferSize;
        }

        public void setChannelTypeEnum(String channelTypeEnum) {
            Objects.requireNonNull(channelTypeEnum, "channelTypeEnum");
            this.channelTypeEnum = ChannelTypeEnum.valueOf(channelTypeEnum);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Builder{");
            sb.append("keepAliveTime=").append(this.keepAliveTime);
            sb.append(", keepAliveTimeout=").append(this.keepAliveTimeout);
            sb.append(", permitKeepAliveTime=").append(this.permitKeepAliveTime);
            sb.append(", maxConnectionIdle=").append(this.maxConnectionIdle);
            sb.append(", maxConcurrentCallsPerConnection=").append(this.maxConcurrentCallsPerConnection);
            sb.append(", maxInboundMessageSize=").append(this.maxInboundMessageSize);
            sb.append(", maxHeaderListSize=").append(this.maxHeaderListSize);
            sb.append(", handshakeTimeout=").append(this.handshakeTimeout);
            sb.append(", flowControlWindow=").append(this.flowControlWindow);
            sb.append(", receiveBufferSize=").append(this.receiveBufferSize);
            sb.append(", channelTypeEnum=").append((Object)this.channelTypeEnum);
            sb.append('}');
            return sb.toString();
        }
    }
}

