/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventMeshTCPSubHandler<ProtocolMessage>
extends SimpleChannelInboundHandler<Package> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventMeshTCPSubHandler.class);
    protected final ConcurrentHashMap<Object, RequestContext> contexts;

    public AbstractEventMeshTCPSubHandler(ConcurrentHashMap<Object, RequestContext> contexts) {
        this.contexts = contexts;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Package msg) throws Exception {
        Preconditions.checkNotNull((Object)msg, (Object)"TCP package cannot be null");
        Preconditions.checkNotNull((Object)msg.getHeader(), (Object)"TCP package header cannot be null");
        Command cmd = msg.getHeader().getCmd();
        log.info("|receive|type={}|msg={}", (Object)cmd, (Object)msg);
        switch (cmd) {
            case REQUEST_TO_CLIENT: {
                this.callback(this.getProtocolMessage(msg), ctx);
                this.response(MessageUtils.requestToClientAck(msg));
                break;
            }
            case ASYNC_MESSAGE_TO_CLIENT: {
                this.callback(this.getProtocolMessage(msg), ctx);
                this.response(MessageUtils.asyncMessageAck(msg));
                break;
            }
            case BROADCAST_MESSAGE_TO_CLIENT: {
                this.callback(this.getProtocolMessage(msg), ctx);
                this.response(MessageUtils.broadcastMessageAck(msg));
                break;
            }
            case SERVER_GOODBYE_REQUEST: {
                break;
            }
            default: {
                log.error("msg ignored|{}|{}", (Object)cmd, (Object)msg);
            }
        }
        RequestContext context = this.contexts.get(RequestContext.key(msg));
        if (context != null) {
            this.contexts.remove(context.getKey());
            context.finish(msg);
        } else {
            log.error("msg ignored,context not found.|{}|{}", (Object)cmd, (Object)msg);
        }
    }

    public abstract ProtocolMessage getProtocolMessage(Package var1);

    public abstract void callback(ProtocolMessage var1, ChannelHandlerContext var2);

    public abstract void response(Package var1);
}

