/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.producer;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.GrpcProducer;
import org.apache.eventmesh.client.grpc.util.EventMeshCloudEventBuilder;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.enums.EventMeshProtocolType;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.Response;
import org.apache.eventmesh.common.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshMessageProducer
implements GrpcProducer<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventMeshMessageProducer.class);
    private static final EventMeshProtocolType PROTOCOL_TYPE = EventMeshProtocolType.EVENT_MESH_MESSAGE;
    private final EventMeshGrpcClientConfig clientConfig;
    private final PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient;

    public EventMeshMessageProducer(EventMeshGrpcClientConfig clientConfig, PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient) {
        this.clientConfig = clientConfig;
        this.publisherClient = publisherClient;
    }

    @Override
    public Response publish(EventMeshMessage message) {
        if (null == message) {
            return null;
        }
        LogUtils.debug((Logger)log, (String)"Publish message: {}", (Object)message);
        CloudEvent cloudEvent = EventMeshCloudEventBuilder.buildEventMeshCloudEvent(message, this.clientConfig, PROTOCOL_TYPE);
        try {
            CloudEvent response = this.publisherClient.publish(cloudEvent);
            Response parsedResponse = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)response)).build();
            LogUtils.info((Logger)log, (String)"Received response:{}", (Object)parsedResponse);
            return parsedResponse;
        }
        catch (Exception e) {
            log.error("Error in publishing message {}", (Object)message, (Object)e);
            return null;
        }
    }

    @Override
    public Response publish(List<EventMeshMessage> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return null;
        }
        CloudEventBatch cloudEventBatch = EventMeshCloudEventBuilder.buildEventMeshCloudEventBatch(messages, this.clientConfig, PROTOCOL_TYPE);
        try {
            CloudEvent response = this.publisherClient.batchPublish(cloudEventBatch);
            Response parsedResponse = Response.builder().respCode(EventMeshCloudEventUtils.getResponseCode((CloudEvent)response)).respMsg(EventMeshCloudEventUtils.getResponseMessage((CloudEvent)response)).respTime(EventMeshCloudEventUtils.getResponseTime((CloudEvent)response)).build();
            LogUtils.info((Logger)log, (String)"Received response:{}", (Object)parsedResponse);
            return parsedResponse;
        }
        catch (Exception e) {
            LogUtils.error((Logger)log, (String)"Error in BatchPublish message {}", messages, (Object)e);
            return null;
        }
    }

    @Override
    public EventMeshMessage requestReply(EventMeshMessage message, long timeout) {
        LogUtils.info((Logger)log, (String)"RequestReply message:{}", (Object)message);
        CloudEvent cloudEvent = EventMeshCloudEventBuilder.buildEventMeshCloudEvent(message, this.clientConfig, PROTOCOL_TYPE);
        try {
            CloudEvent reply = ((PublisherServiceGrpc.PublisherServiceBlockingStub)this.publisherClient.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).requestReply(cloudEvent);
            LogUtils.info((Logger)log, (String)"Received reply message:{}", (Object)reply);
            return (EventMeshMessage)EventMeshCloudEventBuilder.buildMessageFromEventMeshCloudEvent(reply, PROTOCOL_TYPE);
        }
        catch (Exception e) {
            log.error("Error in RequestReply message {}", (Object)message, (Object)e);
            return null;
        }
    }
}

