/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.service.OAuthStateService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;

public class FileOAuthStateService
implements OAuthStateService {
    public static final String DEFAULT_ROOT_DIR = System.getProperty("user.home") + File.separator + ".slack-app";
    private final AppConfig config;
    private final String rootDir;

    public FileOAuthStateService(AppConfig config) throws RuntimeException {
        this(config, DEFAULT_ROOT_DIR);
    }

    public FileOAuthStateService(AppConfig config, String rootDir) throws RuntimeException {
        this.config = config;
        this.rootDir = rootDir;
    }

    @Override
    public void addNewStateToDatastore(String state) throws Exception {
        this.initDirectoryIfAbsent();
        Path filepath = Paths.get(this.getPath(state), new String[0]);
        String value = "" + (System.currentTimeMillis() + this.getExpirationInSeconds() * 1000L);
        Files.write(filepath, value.getBytes(), new OpenOption[0]);
    }

    @Override
    public boolean isAvailableInDatabase(String state) {
        Long millisToExpire = this.findExpirationMillisFor(state);
        return millisToExpire != null && millisToExpire > System.currentTimeMillis();
    }

    @Override
    public void deleteStateFromDatastore(String state) throws Exception {
        this.initDirectoryIfAbsent();
        Path filepath = Paths.get(this.getPath(state), new String[0]);
        Files.delete(filepath);
    }

    private String getBaseDir() {
        return this.rootDir + File.separator + this.config.getClientId();
    }

    private String getPath(String state) {
        return this.getBaseDir() + File.separator + "state" + File.separator + state;
    }

    private Long findExpirationMillisFor(String state) {
        this.initDirectoryIfAbsent();
        try {
            String value = Files.readAllLines(Paths.get(this.getPath(state), new String[0])).stream().collect(Collectors.joining());
            return Long.valueOf(value);
        }
        catch (IOException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void initDirectoryIfAbsent() {
        String dir = this.getBaseDir() + File.separator + "state";
        Path dirPath = Paths.get(dir, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

