/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.retry.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.retry.api.Retryer;
import org.apache.eventmesh.retry.api.timer.HashedWheelTimer;
import org.apache.eventmesh.retry.api.timer.Timer;
import org.apache.eventmesh.retry.api.timer.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryer
implements Retryer {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryer.class);
    private volatile Timer timer;
    private static final int MAX_PENDING_TIMEOUTS = 10000;

    @Override
    public void newTimeout(TimerTask timerTask, long delay, TimeUnit timeUnit) {
        log.debug("[HASHED-WHEEL-TIMER] executed! taskClass={}, nowTime={}", (Object)((Object)((Object)timeUnit)).getClass().getName(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.timer.newTimeout(timerTask, delay, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.timer == null) {
            AbstractRetryer abstractRetryer = this;
            synchronized (abstractRetryer) {
                if (this.timer == null) {
                    this.timer = new HashedWheelTimer((ThreadFactory)new EventMeshThreadFactory("failback-cluster-timer", true), 1L, TimeUnit.SECONDS, 512, 10000L);
                }
            }
        }
        log.info("EventMesh retryer started......");
    }

    @Override
    public void shutdown() {
        this.timer.stop();
        log.info("EventMesh retryer shutdown......");
    }

    @Override
    public long getPendingTimeouts() {
        if (this.timer == null) {
            return 0L;
        }
        return this.timer.pendingTimeouts();
    }

    @Override
    public void printState() {
        if (this.timer == null) {
            log.warn("No HashedWheelTimer is provided!");
            return;
        }
        HashedWheelTimer hashedWheelTimer = (HashedWheelTimer)this.timer;
        log.info("[Retry-HashedWheelTimer] state==================");
        log.info("Running :{}", (Object)(!hashedWheelTimer.isStop() ? 1 : 0));
        log.info("Pending Timeouts: {} | Cancelled Timeouts: {}", (Object)hashedWheelTimer.pendingTimeouts(), (Object)hashedWheelTimer.cancelledTimeouts());
        log.info("========================================");
    }
}

