/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.spi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.spi.EventMeshSPI;
import org.apache.eventmesh.spi.ExtensionException;
import org.apache.eventmesh.spi.loader.ExtensionClassLoader;
import org.apache.eventmesh.spi.loader.JarExtensionClassLoader;
import org.apache.eventmesh.spi.loader.MetaInfExtensionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(EventMeshExtensionFactory.class);
    private static final List<ExtensionClassLoader> EXTENSION_CLASS_LOADERS = new ArrayList<ExtensionClassLoader>();
    private static final ConcurrentHashMap<Extension, Object> EXTENSION_INSTANCE_CACHE = new ConcurrentHashMap(16);

    private EventMeshExtensionFactory() {
    }

    public static <T> T getExtension(Class<T> extensionClass, String extensionName) {
        if (extensionClass == null) {
            throw new ExtensionException("extensionClass is null");
        }
        if (StringUtils.isEmpty((CharSequence)extensionName)) {
            throw new ExtensionException("extensionName is null");
        }
        if (!extensionClass.isInterface() || !extensionClass.isAnnotationPresent(EventMeshSPI.class)) {
            throw new ExtensionException(String.format("extensionClass:%s is invalided", extensionClass));
        }
        EventMeshSPI eventMeshSPIAnnotation = extensionClass.getAnnotation(EventMeshSPI.class);
        if (eventMeshSPIAnnotation.isSingleton()) {
            return EventMeshExtensionFactory.getSingletonExtension(extensionClass, eventMeshSPIAnnotation, extensionName);
        }
        return EventMeshExtensionFactory.getPrototypeExtension(extensionClass, extensionName);
    }

    private static <T> T getSingletonExtension(Class<T> extensionClass, EventMeshSPI spi, String extensionInstanceName) {
        return (T)EXTENSION_INSTANCE_CACHE.computeIfAbsent(new Extension(spi, extensionInstanceName), name -> {
            Class extensionInstanceClass = EventMeshExtensionFactory.getExtensionInstanceClass(extensionClass, extensionInstanceName);
            if (extensionInstanceClass == null) {
                log.warn("Get extension instance class {} is null", (Object)extensionClass.getName());
                return null;
            }
            try {
                Object extensionInstance = extensionInstanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigService.getInstance().populateConfigForObject(extensionInstance);
                log.info("initialize extension instance success, extensionClass: {}, extensionInstanceName: {}", (Object)extensionClass, (Object)extensionInstanceName);
                return extensionInstance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExtensionException("Extension initialize error", e);
            }
            catch (IOException | NoSuchFieldException e) {
                log.error("initialize extension instance config failed, extensionClass: {}, extensionInstanceName: {}", new Object[]{extensionClass, extensionInstanceName, e});
                throw new ExtensionException("Extension initialize error", e);
            }
        });
    }

    private static <T> T getPrototypeExtension(Class<T> extensionType, String extensionInstanceName) {
        Class<T> extensionInstanceClass = EventMeshExtensionFactory.getExtensionInstanceClass(extensionType, extensionInstanceName);
        if (extensionInstanceClass == null) {
            return null;
        }
        try {
            T extensionInstance = extensionInstanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigService.getInstance().populateConfigForObject(extensionInstance);
            log.info("initialize extension instance success, extensionType: {}, extensionName: {}", extensionType, (Object)extensionInstanceName);
            return extensionInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExtensionException("Extension initialize error", e);
        }
        catch (IOException | NoSuchFieldException e) {
            log.error("initialize extension instance config failed, extensionType: {}, extensionInstanceName: {}", new Object[]{extensionType, extensionInstanceName, e});
            throw new ExtensionException("Extension initialize error", e);
        }
    }

    private static <T> Class<T> getExtensionInstanceClass(Class<T> extensionType, String extensionInstanceName) {
        for (ExtensionClassLoader extensionClassLoader : EXTENSION_CLASS_LOADERS) {
            Map<String, Class<?>> extensionInstanceClassMap = extensionClassLoader.loadExtensionClass(extensionType, extensionInstanceName);
            Class<?> instanceClass = extensionInstanceClassMap.get(extensionInstanceName);
            if (instanceClass == null) continue;
            return instanceClass;
        }
        return null;
    }

    static {
        EXTENSION_CLASS_LOADERS.add(MetaInfExtensionClassLoader.getInstance());
        EXTENSION_CLASS_LOADERS.add(JarExtensionClassLoader.getInstance());
    }

    private static class Extension {
        private EventMeshSPI spi;
        private String extensionInstanceName;

        public Extension(EventMeshSPI spi, String extensionInstanceName) {
            this.spi = spi;
            this.extensionInstanceName = extensionInstanceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Extension)) {
                return false;
            }
            Extension extension = (Extension)o;
            return Objects.equals(this.spi, extension.spi) && Objects.equals(this.extensionInstanceName, extension.extensionInstanceName);
        }

        public int hashCode() {
            return Objects.hash(this.spi, this.extensionInstanceName);
        }
    }
}

