/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.view.AutoValue_InstrumentSelector;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class InstrumentSelector {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");

    public static Builder builder() {
        return new AutoValue_InstrumentSelector.Builder().setInstrumentNamePattern(MATCH_ALL);
    }

    public abstract InstrumentType getInstrumentType();

    public abstract Pattern getInstrumentNamePattern();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInstrumentType(InstrumentType var1);

        abstract Builder setInstrumentNamePattern(Pattern var1);

        public final Builder setInstrumentNameRegex(String regex) {
            return this.setInstrumentNamePattern(Pattern.compile(Objects.requireNonNull(regex, "regex")));
        }

        public abstract InstrumentSelector build();
    }
}

