/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc;

import java.util.List;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.table.catalog.CatalogSchema;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.Table;

public class CatalogChanges {
    private String type;
    private String operationType;
    private CatalogSchema catalog;
    private Table table;
    private List<? extends Column> columns;

    private CatalogChanges(String type, String operationType, CatalogSchema catalog, Table table, List<? extends Column> columns) {
        this.type = type;
        this.operationType = operationType;
        this.catalog = catalog;
        this.table = table;
        this.columns = columns;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public CatalogSchema getCatalog() {
        return this.catalog;
    }

    public Table getTable() {
        return this.table;
    }

    public List<? extends Column> getColumns() {
        return this.columns;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public void setCatalog(CatalogSchema catalog) {
        this.catalog = catalog;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(List<? extends Column> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogChanges)) {
            return false;
        }
        CatalogChanges other = (CatalogChanges)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operationType = this.getOperationType();
        String other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
            return false;
        }
        CatalogSchema this$catalog = this.getCatalog();
        CatalogSchema other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !((Object)this$catalog).equals(other$catalog)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        List<? extends Column> this$columns = this.getColumns();
        List<? extends Column> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatalogChanges;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
        CatalogSchema $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : ((Object)$catalog).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        List<? extends Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "CatalogChanges(type=" + this.getType() + ", operationType=" + this.getOperationType() + ", catalog=" + this.getCatalog() + ", table=" + this.getTable() + ", columns=" + this.getColumns() + ")";
    }

    public static class Builder {
        private String type;
        private String operationType;
        private CatalogSchema catalog;
        private Table table;
        private List<? extends Column> columns;

        public Builder operationType(SchemaChangeEventType changeEventType) {
            this.type = changeEventType.ofType();
            this.operationType = changeEventType.ofOperationType();
            return this;
        }

        public Builder catalog(CatalogSchema catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder table(Table table) {
            this.table = table;
            return this;
        }

        public Builder columns(List<? extends Column> columns) {
            this.columns = columns;
            return this;
        }

        public CatalogChanges build() {
            return new CatalogChanges(this.type, this.operationType, this.catalog, this.table, this.columns);
        }
    }
}

