/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc;

import java.util.HashMap;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.DataChanges;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;

public final class Payload
extends HashMap<String, Object> {
    public static final String AFTER_FIELD = "after";
    public static final String BEFORE_FIELD = "before";
    public static final String SOURCE = "source";
    public static final String DDL = "ddl";

    public Payload() {
        this.put("timestamp", System.currentTimeMillis());
    }

    public Payload withSource(SourceMateData source) {
        this.put(SOURCE, source);
        return this;
    }

    public Payload withDdl(String ddl) {
        this.put(DDL, ddl);
        return this;
    }

    public Payload withCatalogChanges(CatalogChanges catalogChanges) {
        this.put("catalogChanges", catalogChanges);
        return this;
    }

    public Payload withDataChanges(DataChanges dataChanges) {
        this.put("dataChanges", dataChanges);
        return this;
    }

    public SourceMateData ofSourceMateData() {
        return (SourceMateData)super.get(SOURCE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Payload payload = new Payload();

        private Builder() {
        }

        public Builder put(String key, Object value) {
            this.payload.put(key, value);
            return this;
        }

        public Builder withSource(SourceMateData source) {
            this.payload.put(Payload.SOURCE, source);
            return this;
        }

        public Payload build() {
            return this.payload;
        }
    }
}

