/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.connector.jdbc.source.JdbcTaskManager;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerCoordinator {
    private static final Logger log = LoggerFactory.getLogger(TaskManagerCoordinator.class);
    private static final int BATCH_MAX = 10;
    private static final int DEFAULT_QUEUE_SIZE = 8192;
    private BlockingQueue<ConnectRecord> recordBlockingQueue = new LinkedBlockingQueue<ConnectRecord>(8192);
    private Map<String, JdbcTaskManager> taskManagerCache = new HashMap<String, JdbcTaskManager>(8);

    public void registerTaskManager(String name, JdbcTaskManager taskManager) {
        this.taskManagerCache.put(name, taskManager);
    }

    public void init() {
        this.taskManagerCache.values().forEach(JdbcTaskManager::init);
        this.taskManagerCache.values().forEach(taskManager -> taskManager.registerListener(records -> {
            if (CollectionUtils.isEmpty((Collection)records)) {
                return;
            }
            records.forEach(record -> {
                try {
                    this.recordBlockingQueue.put((ConnectRecord)record);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }));
    }

    public void start() {
        this.taskManagerCache.values().forEach(JdbcTaskManager::start);
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> records = new ArrayList<ConnectRecord>(10);
        for (int index = 0; index < 10; ++index) {
            try {
                ConnectRecord record = this.recordBlockingQueue.poll(3L, TimeUnit.SECONDS);
                if (Objects.isNull(record)) break;
                records.add(record);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return records;
    }
}

